#version 330 core
in vec2 UV;
out vec4 color;
uniform float wa;
uniform float wb;
uniform float wc;
uniform float invx;
uniform float invy;
uniform sampler2D tex;
uniform sampler2D dirtexA;
uniform sampler2D dirtexB;
uniform sampler2D dirtexC;

uniform sampler2D exLogo;
uniform sampler2D exTitle;
uniform sampler2D exCred;
uniform float logoConst;
uniform float logoSpecialFade;
uniform float titleConst;
uniform float credConst;
uniform float textOffx;
uniform float textOffy;

vec4 drawTexts()
{
  const float scale = 1.5;
  vec2 uv = vec2(UV.x*scale - 0.1*textOffx, 1.0 - UV.y*scale - 0.1*textOffy);

  vec2 uvLogo  = clamp(vec2(uv.x, 2.15*uv.y), vec2(0.0), vec2(1.0));
  vec2 uvTitle = clamp(vec2(uv.x, 0.9*uv.y), vec2(0.0), vec2(1.0));
  vec2 uvCred  = clamp(vec2(uv.x, 4.5*uv.y), vec2(0.0), vec2(1.0));

  // Yes, this is a pure fucking hack (for the subtitle fade)
  float fade = 1.0;
  if(logoSpecialFade >= 0.0)
  {
    float x = pow(1.0-pow(uvLogo.x, logoSpecialFade), 100.0);
    fade    = clamp(x+pow(1.0-pow(uvLogo.y, 70.0), 1000000.0), 0.0, 1.0);
  }
  
  vec4 textbuf = sqrt(logoConst)  * texture(exLogo,  uvLogo )*fade +
                 sqrt(titleConst) * texture(exTitle, uvTitle) +
                 sqrt(credConst)  * texture(exCred,  uvCred );
  // blueish hue to the fades, old film style
  textbuf.b /= pow(0.0001+logoConst+titleConst+credConst, 0.333);
  return textbuf;
}

void main() {
	vec2 dirA = normalize(texture(dirtexA, UV).rg - vec2(0.5));
	vec2 dirB = normalize(texture(dirtexB, UV).rb - vec2(0.5));
	vec2 dirC = normalize(texture(dirtexC, UV).gr - vec2(0.5));
	vec2 inv = vec2(invx, invy);
	color = vec4(0.0);
	for ( int i = 0; i < 16; i++ ) {
		color.rg += 0.33 * texture(tex, UV + i * dirA * inv).rg;
		color.rb += 0.33 * texture(tex, UV + i * dirB * inv).rb;
		color.gr += 0.33 * texture(tex, UV + i * dirC * inv).gr;
	}

	color += drawTexts();
	color += texture(tex, UV);
}
