#version 330 core
in vec2 UV;
out vec4 color;
uniform float wa;
uniform float wb;
uniform float wc;
uniform float invx;
uniform float invy;
uniform sampler2D tex;
uniform sampler2D dirtexA;
uniform sampler2D dirtexB;
uniform sampler2D dirtexC;

void main() {
	vec2 dirA = normalize(texture(dirtexA, UV).rg - vec2(0.5));
	vec2 dirB = normalize(texture(dirtexB, UV).rb - vec2(0.5));
	vec2 dirC = normalize(texture(dirtexC, UV).gr - vec2(0.5));
	vec2 inv = vec2(invx, invy);
	color = vec4(0.0);
	for ( int i = 0; i < 16; i++ ) {
		color.rg += 0.33 * texture(tex, UV + i * dirA * inv).rg;
		color.rb += 0.33 * texture(tex, UV + i * dirB * inv).rb;
		color.gr += 0.33 * texture(tex, UV + i * dirC * inv).gr;
	}
	color = color + texture(tex, UV);
}
