//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDfff71a25_591f_44ed_9f7b_f7e975a559ad
{
    public class Class_Clamp : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Value = 0,
            Min = 1,
            Max = 2
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Value = inputs[(int)InputId.Value].Eval(context).Value;
            var Min = inputs[(int)InputId.Min].Eval(context).Value;
            var Max = inputs[(int)InputId.Max].Eval(context).Value;
            //<<< _params

            if (Min > Max) 
                Utilities.Swap(ref Min, ref Max);
            
            context.Value = Utilities.Clamp((float)Value, (float)Min, (float)Max);

            return context;
        }
    }
}

