#version 330
in vec2 vTexCoord;

layout( location = 0 ) out float outColor;

uniform sampler2DMS uTexSampler;
uniform int uSampleCount;
uniform vec2 uResolution;

void main()
{
	float depth = 0.0;
	for( int i = 0; i < uSampleCount; i++ )
	{
		depth += texelFetch( uTexSampler, ivec2(vTexCoord * uResolution), i ).r;
	}
	depth /= float(uSampleCount);
	outColor = depth;
}