#version 330

in vec2 vTexCoord;

layout( location = 0 ) out vec4 outColor;

uniform sampler2D uTexSampler;
uniform sampler2D uTexSampler2;
uniform float uBloomDry;
uniform float uBloomWet;
uniform float uExposure;
uniform float uFlash;
uniform float uVignette;
uniform vec4 uColorCorrection;

uniform float uFade;


void main()
{
	vec4 original = texture( uTexSampler, vTexCoord );
	vec4 blurred = texture( uTexSampler2, vTexCoord );

	vec4 color = ( original * uBloomDry ) + ( blurred * uBloomWet );

	vec2 imgTexCoord = vTexCoord - 0.5;

	float vignette = 1 - dot( imgTexCoord, imgTexCoord );
	
	vec4 color_correction = uColorCorrection * uFlash;

	color += color_correction;

	color *= pow( vignette, uVignette );

	color *= uExposure; //Exposure level

	outColor = ( color * uFade );//pow( color, vec4( 0.55 ) ); //Gamma
}