#version 330

in vec2 vTexCoord;

layout( location = 0 ) out vec4 outColor;

uniform sampler2D uTexSampler;
uniform vec2 uTexelSize;
uniform vec2 uBlurDirection;
uniform float uBlurMagnitude;

float Weights[9] = float[9]( 0.2, 0.4, 0.7, 0.9, 1.0, 0.9, 0.7, 0.4, 0.2 );

void main()
{
	vec4 color = vec4( 0.0 );
	float sum = 0.0;
	for( int i = 0; i < 9; i++ )
	{
		sum += Weights[i];
	}
	for( int i = -4; i <= 4; i++ )
	{
		vec2 texCoordOffset = uBlurDirection * ( uTexelSize * i );
		color += ( texture( uTexSampler, vTexCoord + texCoordOffset ) ) * ( Weights[i+4] * uBlurMagnitude );
	}
	color /= sum;
	outColor = color;
}