// JavaScript source code

//Namespace
this.wideload = this.wideload || {};

(function(){

    var Configuration = function () { }

    var p = Configuration.prototype;
    
    //Expose
    wideload.Configuration = Configuration;
	
	var wps = musicDreamEnd; // WalkingMan part start (44100)
    var dreampart = 6500;
	p.charSpeed = 20;
    p.parts=[
    	{part: "Noise", startTime:0, endTime: dreampart, position:0},
    	{part: "DreamWord", startTime:dreampart, endTime: musicDreamEnd-584*barLength, position:0},
		{part: "Dream", startTime:dreampart, endTime: musicDreamEnd-584*barLength, position:0},
		{part: "WalkingMan", startTime:wps, position:0},
    	{part: "Day", startTime:wps, position:0},
    	{part: "Clock", startTime:wps-584*barLength, endTime: wps+barLength*2568, position:100 },
    	{part: "City", startTime:wps-584*barLength, endTime: wps +9912*barLength, position:-780},
    	{part: "Brickroad", startTime:wps +barLength*9912, endTime: wps +barLength*9912+150000, position:0},
    	{part: "Butterflies", startTime:wps +barLength*9912+8000, endTime: 124000, position:50},
    	{part: "Earth", startTime:wps +barLength*9912, endTime: 25000000, position:0},
    	{part: "Hay", startTime:wps, endTime: 250000000, position:0},
    	{part: "Forest", startTime:wps +barLength*9912+9100*barLength, endTime: 250000000, position:0},
    	{part: "Glass", startTime:250000000, endTime: 250000000, position:0},
        {part: "Water", startTime:wps +barLength*9912, endTime: 250000000, position:0},
    ];
	
	/*Actions: 
		-Follow -> follow char. lookAt is instantiated at the point of moving to camera
		-Static -> position & look.
		-Bezier -> Run through Bezier points
	*/
    p.cameraDrive=[
		//Clock
        {   begin: 0, end: dreampart,
            "action": "static", charpos: 70, position: new THREE.Vector3(0, 0,-10) ,lookAt: new THREE.Vector3(0.0, 0.0,0.0), },
        {   begin: dreampart, end: wps-584*barLength, //Dream 
            "action": "static", charpos: 170, position: new THREE.Vector3(0, 90,120) ,lookAt: new THREE.Vector3(0.0, 10,0), },
		{	begin: wps-584*barLength, end: wps +=488*barLength, //Clock
			"action": "static", charpos: 170, position: new THREE.Vector3(0, 73,233) ,lookAt: new THREE.Vector3(0.0, 73.0,-10.999), },
		{	begin: wps, end: wps +=4550*barLength, charpos: 70 + 1.5*p.charSpeed, //previous movement2
			"action": "bezier", addCharPos:false, 
			positions: [
							new THREE.Vector3(0,73,233),
							new THREE.Vector3(-10,33,193),
							new THREE.Vector3(-12, 6,223),
							new THREE.Vector3(37, 17,353),
							new THREE.Vector3(50, 17,603),
						], 
			rotations: [
							new THREE.Vector3(0.0,0.0,0.0),
							new THREE.Vector3(-0.4,-0.5,0.0),
							new THREE.Vector3(0,-3.14,-0.00),
							new THREE.Vector3(0,-3.14,-0.00),
							new THREE.Vector3(0,-3.14,-0.00),
				
			] },
		
		//Townwalk
		{	begin: wps, end: wps += 4875*barLength,
			"action": "follow", charpos: 70+1.5*p.charSpeed+17*p.charSpeed, position: new THREE.Vector3(4.406, 10.395,2.526) ,rotation: new THREE.Vector3(0.840, 0.399,-0.24), },
			
		//Road
		{	begin: wps, end: wps += 3250*barLength, charpos: 0, charSpeed: 5,
			"action": "bezier", addCharPos:false, 
			positions: [
							new THREE.Vector3(0,4,-5),
							new THREE.Vector3(4,10,0),
							new THREE.Vector3(10, 14,5),
							new THREE.Vector3(20, 14,25),
							new THREE.Vector3(0, 3,25),
							new THREE.Vector3(0, 4,35),
						], 
			rotations: [
							new THREE.Vector3(-2.9,0.00,-3.34),
							new THREE.Vector3(-2.9,0.00,-3.34),
							new THREE.Vector3(-2.9,0.40,-2.84),
							new THREE.Vector3(-2.5,0.30,1.74),
							new THREE.Vector3(-2.0,0.24,3.08),
				
			] },
			
		
		{	begin: wps, end: wps += 6500*barLength, charpos: 17, charSpeed: 8,
			"action": "bezier", addCharPos:false, 
			positions: [
							new THREE.Vector3(0,4,35),
							new THREE.Vector3(4,10,40),
							new THREE.Vector3(10, 24,40),
							new THREE.Vector3(20, 44,35),
							new THREE.Vector3(0, 40,50),
							new THREE.Vector3(0, 20,90),
							new THREE.Vector3(30, 10,140),
							new THREE.Vector3(40, 7,170),
							new THREE.Vector3(40, 7,210),
						], 
			rotations: [
							new THREE.Vector3(-2.0,0.24,3.08),
							new THREE.Vector3(-2.9,0.00,3.08),
							new THREE.Vector3(-2.9,0.00,3.08),
							new THREE.Vector3(-2.9,0.00,3.08),
							new THREE.Vector3(-2.9,0.00,3.08),
							new THREE.Vector3(-2.9,1.00,3.08),
							new THREE.Vector3(-2.9,1.70,3.08),
				
			] },
			{	begin: wps, end: wps += 10050*barLength, charpos: 17+160, charSpeed: 7,
			"action": "bezier", addCharPos:false, 
			positions: [
							new THREE.Vector3(40, 7,210),
							new THREE.Vector3(120, 57,390),
							new THREE.Vector3(160, 97,490),
						], 
			rotations: [
							new THREE.Vector3(-2.9,1.70,3.08),
							new THREE.Vector3(-2.9,1.70,3.08),
							new THREE.Vector3(-2.9,0.3,3.08),
				
			] },
			
			{	begin: wps, end: wps += 3050*barLength, charpos: 600, charSpeed: 7,
			"action": "bezier", addCharPos:false, 
			positions: [
							new THREE.Vector3(160, 97,490),
							new THREE.Vector3(130, 47,510),
							new THREE.Vector3(6, 27,597),
							new THREE.Vector3(-13, 27,622),
						], 
			rotations: [
							new THREE.Vector3(-2.9,0.3,3.08),
							new THREE.Vector3(-2.9,0.3,3.08),
							new THREE.Vector3(-3.12,-0.23,3.02),
							new THREE.Vector3(-3.12,-0.23,3.14),
				
			] },
		

    ]
	
	p.init = function()
	{
		for(var i = 0; i < this.cameraDrive.length; i++)
		{
			var camo = this.cameraDrive[i];
			if(camo.action == "bezier")
			{
				camo.path = new THREE.SplineCurve3(camo.positions);
				camo.rotPath = new THREE.SplineCurve3(camo.rotations);
				
			}
		}
	}
    
}());
