/**
 * ...
 * @author Henri Sarasvirta
 */

(function() {
	
	var butterfly = new Image();
	butterfly.src = "data:image/png;base64,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"
	window.Asset.register("paper", butterfly);	
		
	
})();