﻿SwipeShader = {

	attributes:{
		
	},
	
	uniforms: {

		"scene1":   { type: "t", value: null },
    "scene2":   { type: "t", value: null },
    "angle":    { type: "f", value: -2.0},
    "resolution": { type: "v2", value: null}

	},

	vertexShader: [

		"varying vec2 vUv;",

		"void main() {",

			"vUv = uv;",

			"gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );",

		"}"

	].join("\n"),

	fragmentShader: [
    "uniform float angle;",
    "uniform sampler2D scene1;",
    "uniform sampler2D scene2;",
    "uniform vec2 resolution;",
    "varying vec2 vUv;",
    
    "void main() {",
      "vec2 uv = gl_FragCoord.xy / resolution.xy;",
      
      "float mixi = dot(uv.x, uv.y)+angle;",
      
      "vec4 to = texture2D(scene2, vUv);",
      "vec4 from = texture2D(scene1, vUv);",
      "gl_FragColor = mix(to, from, smoothstep(0.5, -0.25, mixi));",
      
    "}"
    
	].join("\n")

};