varying vec2 v_pos;

void main()
{
	v_pos = gl_Vertex.xy;
	gl_Position = ftransform();
}

//____FRAGMENT_SHADER____

varying vec2 v_pos;
uniform float u_time, u_aspect;
uniform float u_offset, u_freq;
uniform vec3 u_col1, u_col2;

void main()
{
	float angle = atan(v_pos.x, v_pos.y) / 3.14159 * 8.0 + u_time * 4.0;
	float dist = length(v_pos.xy * vec2(1.0, u_aspect));
	vec3 col = mix(u_col1, u_col2, step(mod(angle + sin(dist * u_freq + u_offset * 4.0), 1.0), 0.5));

	gl_FragColor = vec4(col, 1.0);
}