#version 330 core

uniform vec4 time;
uniform sampler2D tex0;
uniform vec4 opasity;
uniform vec4 twist;
uniform vec4 ofs;

in vec2 texcoord0;

layout(location = 0, index = 0) out vec4 out_color0;

void main(void)
{
	vec2 p = 2.0f * texcoord0 - 1.0f;

	float a = atan(p.y,p.x);
	float r = sqrt(dot(p,p));

	float t = time.x + ofs.x;

	vec2 uv;
	uv.x = 0.75f * t + 0.1f/ r;
	uv.y = a / 3.1416f;

	uv.y += twist.x * sqrt(r);

	uv *= 2;

	vec3 col = texture(tex0, uv).xyz;

	out_color0 = vec4( col*r*r * opasity.x, 1 );
}
