#version 330 core

layout(location = 0, index = 0) out vec4 out_color0;

in vec3 ws_norm;
in vec3 vs_pos;
in vec3 vs_norm;

float sat( float a ) {
	return clamp( a, 0, 1 );
}

void main()
{
	float dp = 1-dot( normalize(-vs_pos), normalize(vs_norm) );
	dp = 0.7 * sat( pow( dp, 3 ) );

	vec3 ws_n = normalize( ws_norm );
	float upfacing = 0.5 * pow( sat(ws_n.y+0.05), 5 );

	out_color0 = vec4( mix(vec3(1,0.75f,0.3f), vec3(1,1,1), sat(dp+upfacing) ), 1 ); 
}
