#version 120

uniform vec4 EyePos;
uniform vec4 Misc2;

varying vec3 normal;
varying vec3 pos;
varying vec2 uv;

void main(void)
{
	vec3 norm = normal;
	
	if ( !gl_FrontFacing ) { norm *= -1.0f;}
	
	vec3 vecToEye = EyePos.xyz - pos;
	vec3 vecToEyeNorm = normalize(vecToEye);
	
	float alpha = Misc2.z;
	float fresnel = max(0.0f, pow(1.0f-dot(vecToEyeNorm, norm), 2.20f) );

	//gl_FragColor = vec4(norm,1.0f);	
	gl_FragColor = vec4( norm+vec3(fresnel*5.0f), fresnel*Misc2.y*alpha );	
}