/*
 * Decompiled with CFR 0.152.
 */
package pw.svn.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import pw.svn.util.MessageManipulator;
import pw.svn.util.NameGenerator;

public class ChatServer
implements Runnable {
    private transient List<ClientConnection> clients = new ArrayList<ClientConnection>();
    private transient int port;
    private transient ResourceBundle messages;

    public ChatServer(String ip, int port, ResourceBundle messages) {
        this.port = port;
        this.messages = messages;
        new Thread(this).start();
    }

    @Override
    public void run() {
        this.startServer();
    }

    private void startServer() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(this.port);
            while (true) {
                System.out.println(this.messages.getString("listeningForConnections"));
                Socket clientSocket = serverSocket.accept();
                ClientConnection connection = new ClientConnection(this.clients.size(), clientSocket);
                this.clients.add(connection);
                System.out.printf("%s %d%n", this.messages.getString("connectionAdded"), this.clients.size() - 1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    private class ClientConnection
    implements Runnable {
        private final int id;
        private final String name;
        private final Socket socket;
        private ObjectOutputStream output;
        private ObjectInputStream input;

        public ClientConnection(int id, Socket socket) {
            this.id = id;
            this.name = NameGenerator.getNewName();
            this.socket = socket;
            new Thread(this).start();
        }

        @Override
        public void run() {
            this.initializeClientConnection();
            this.enterChat();
        }

        private void initializeClientConnection() {
            try {
                this.output = new ObjectOutputStream(this.socket.getOutputStream());
                this.output.flush();
                this.input = new ObjectInputStream(this.socket.getInputStream());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void enterChat() {
            this.sendToAllf("\t%s %s", this.name, ChatServer.this.messages.getString("hasEnteredChat"));
            while (true) {
                String message;
                if ((message = this.readMessage()) == null) break;
                this.sendToAllf("%s: %s", this.name, MessageManipulator.manipulate(message));
            }
            this.leaveChat();
        }

        private void leaveChat() {
            ChatServer.this.clients.remove(this);
            this.sendToAllf("\t%s %s", this.name, ChatServer.this.messages.getString("hasLeftChat"));
        }

        private String readMessage() {
            String data = null;
            try {
                data = (String)this.input.readObject();
            }
            catch (IOException | ClassNotFoundException exception) {
                // empty catch block
            }
            return data;
        }

        private void sendMessage(String message) {
            try {
                this.output.writeObject(message);
                this.output.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void sendToAll(String message) {
            if (message == null) {
                return;
            }
            for (ClientConnection client : ChatServer.this.clients) {
                client.sendMessage(message);
            }
        }

        private void sendToAllf(String s, Object ... o) {
            String message = String.format(s, o);
            this.sendToAll(message);
        }

        public boolean equals(Object o) {
            if (!(o instanceof ClientConnection)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            return this.id == ((ClientConnection)o).id;
        }
    }
}

