/*
 * Decompiled with CFR 0.152.
 */
package pw.svn.client;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ChatClient
implements Runnable {
    private String serverAddress;
    private int serverPort;
    private Socket serverConnection;
    private ObjectOutputStream output;
    private ObjectInputStream input;
    public static final int DEFAULT_WIDTH = 480;
    public static final int DEFAULT_HEIGHT = 600;
    private JFrame ui;
    private JTextArea textAreaMessages;
    private Point position;
    private ResourceBundle messages;

    public ChatClient(String serverAddress, int serverPort, ResourceBundle messages, Point position) {
        this.messages = messages;
        this.serverAddress = serverAddress;
        this.serverPort = serverPort;
        this.position = position;
        new Thread(this).start();
    }

    @Override
    public void run() {
        this.initializeUI();
        this.startClient(this.serverAddress, this.serverPort);
    }

    private void initializeUI() {
        this.ui = new JFrame(this.messages.getString("title"));
        this.ui.setDefaultCloseOperation(1);
        this.textAreaMessages = new JTextArea();
        this.textAreaMessages.setEditable(false);
        this.textAreaMessages.setLineWrap(true);
        this.textAreaMessages.setWrapStyleWord(true);
        this.ui.add(new JScrollPane(this.textAreaMessages));
        final JTextField textFieldMessage = new JTextField();
        textFieldMessage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String message = textFieldMessage.getText();
                ChatClient.this.sendMessage(message);
                textFieldMessage.setText("");
            }
        });
        this.ui.add((Component)textFieldMessage, "South");
        this.ui.setLocationRelativeTo(null);
        this.ui.setSize(480, 600);
        this.ui.setLocation(this.position);
        this.ui.setVisible(true);
    }

    private void startClient(String serverAddress, int serverPort) {
        try {
            try {
                this.serverConnection = new Socket(serverAddress, serverPort);
                this.output = new ObjectOutputStream(this.serverConnection.getOutputStream());
                this.input = new ObjectInputStream(this.serverConnection.getInputStream());
                while (true) {
                    this.displayMessage(this.readMessage());
                }
            }
            catch (IOException e) {
                this.displayMessage(this.messages.getString("connectionFailed"));
                this.displayMessage(this.messages.getString("shuttingDown"));
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
                System.exit(0);
            }
        }
        catch (Throwable throwable) {
            this.displayMessage(this.messages.getString("shuttingDown"));
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.exit(0);
            throw throwable;
        }
    }

    private void displayMessage(String message) {
        this.textAreaMessages.append(message.concat(System.getProperty("line.separator")));
        this.textAreaMessages.setCaretPosition(this.textAreaMessages.getText().length());
    }

    private String readMessage() {
        String message = null;
        try {
            message = (String)this.input.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        return message;
    }

    public void sendMessage(String message) {
        try {
            this.output.writeObject(message.concat(" "));
            this.output.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

