uniform mat4 Proj, View, ViewInverse;

uniform vec3 EyePos;

uniform vec3 Pos;
uniform float Rad;

varying vec3 PixelWorld;

void main()
{
	vec4 worldPos = vec4(Pos, 1);
	vec4 viewPos = (View * worldPos) + vec4(gl_Vertex.xy * Rad * 1.4, 0, 0);

	PixelWorld = (ViewInverse * viewPos).xyz;
	
	gl_Position = Proj * viewPos;
}
