void main()
{
	
	vec3 normal = normalize(worldPos);
	float height = normal.y;

	vec3 l = normalize(lightPos - worldPos);

	float th = max(height,-0.5)*7.0;
	float r = th*0.5;
	float g = th*0.3;
	float b = th*0.3;
	vec4 sky_color = vec4(1.1-r,1.3-g,1.7-b,1.0)/2.0*clamp(l.y*5.5,0.0,1.0); 

	float diffuseAmt = clamp(pow(max(1.04*dot(normal, l), 0.0)/1.02,45.0),0.0,1.75);
	float diffuseAmt2 =pow(max(dot(normal, l)/15.0, 0.),0.5);
	vec4 sun = vec4(vec3(diffuseAmt) * vec3(1.0,0.6392,0.0),1);
	vec4 diffuse =vec4(vec3(diffuseAmt2),1) *clamp(l.y,0.0,1.0);
	vec4 finalColor = diffuse + sky_color + sun;

	
	vec4 cloud = mix(vec4(1.0,1.0,1.0,1.0),vec4(0.0,0.0,0.0,1.0),clamp(noised(mat2(0.6,-0.5,-0.9,-.6)* vec2(tCoords.x*54.0/(worldPos.y*.75)+l.y,tCoords.y*54.0/(worldPos.y*.75)+l.y)).x,0.0,1.0));
	cloud *= clamp(l.y*3.0+0.85,0.2,1.0);
	
	

	float maxFogDistance = 20.0;
	vec3 orange = mix(vec3(.7, .8, .8),vec3(1.0,0.6392,0.098),clamp(l.y*4.0,0.0,0.85))*clamp(l.y,0.0,1.0);
	vec3 fogColor = getFogColor(viewPosition,lightPos,worldPos)*clamp(l.y*2.0+0.85,0.1,1.0);
	vec3 fogColor2 = getFogColor(viewPosition,lightPos,worldPos)*clamp(worldPos.y/5.0,0.5,1.0);
	cloud *= vec4(fogColor2,1.0);
	finalColor += cloud*(normal.y*4.0);

	gl_FragColor = vec4(mix(fogColor/1.5, finalColor.xyz, clamp(l.y,0.5,1.0)), 1);
}