uniform mat4 Proj,View,World;
uniform vec3 LightPos,LightPos2;
uniform vec3 mag1,mag2,mag3,mag4,mag5;
varying vec3 norms;
varying vec4 verts;
void main()
{
	norms = normalize(gl_Normal);
	float range = 0.5;				//magnet effective range
	float range2 = range*range;
	vec3 MV =gl_Vertex.xyz - mag1;
	float alpha =  -range2 / (range2 + dot(MV,MV));
	vec3 p = alpha * mag1 + (1-alpha) * gl_Vertex.xyz;

	MV = p - mag2;
	alpha = -range2 / (range2 + dot(MV,MV));
	p = alpha * mag2 + (1-alpha) * p;

	MV = p - mag3;
	alpha = range2 / (range2 + dot(MV,MV));
	p = alpha * mag3 + (1-alpha) * p;

	MV = p - mag4;
	alpha = -range2 / (range2 + dot(MV,MV));
	p = alpha * mag4 + (1-alpha) * p;

	MV = p - mag5;
	alpha = range2 / (range2 + dot(MV,MV));
	p = alpha * mag5 + (1-alpha) * p;

	gl_FrontColor = gl_Color;
	verts = gl_Vertex;
	tCoords = gl_MultiTexCoord0.xy;
	lightPos = LightPos;
	lightPos2 = LightPos2;
	worldPosition = World * vec4(p,gl_Vertex.w);
	worldPos = worldPosition.xyz;
	viewPosition = View * worldPosition;
	eyevec = viewPosition.xyz;
	gl_Position = Proj * viewPosition;
}