void main()
{
	vec4 diffuse = vec4(0.5,0.5,0.5,1.0);
	
	float h1 = terrainHeight(tCoords);
	h1  += terrainHeight(tCoords/5.0,2)*5.5;
	float off = .01;
	float h2 = terrainHeight(tCoords.xy + vec2(off, 0));
	h2 += terrainHeight((tCoords.xy+ vec2(off, 0))/5.0,2)*5.5;
	float h3 = terrainHeight(tCoords.xy + vec2(-off, 0));
	h3 += terrainHeight((tCoords.xy+ vec2(-off, 0))/5.0,2)*5.5;
	float h4 = terrainHeight(tCoords.xy + vec2(0, off));
	h4 += terrainHeight((tCoords.xy+ vec2(0, off))/5.0,2)*5.5;
	float h5 = terrainHeight(tCoords.xy + vec2(0, -off));
	h5 += terrainHeight((tCoords.xy+ vec2(0, -off))/5.0,2)*5.5;

	vec3 normal = normalize(vec3(h2-h3, .016, h5-h4));

	float maxFogDistance = 13.0;

	vec3 newWorldPos = vec3(tCoords.x,h1,tCoords.y);
	vec3 l = normalize(lightPos - newWorldPos);

	vec3 snowColor = vec3(1.0);
	vec3 slateColor =vec3(.5804,.5451,.4863)/24.0;
	vec3 rockColor = vec3(.09,.1015,.1015)/12.0;
	slateColor = mix(slateColor,rockColor,clamp(tnoised( vec2(tCoords.x*12.0,tCoords.y*12.0)).x/2.0,0.0,1.0) );
	vec3 treeColor1 = mix(vec3(.10725, .134, 0.1255),vec3(.34725, .274, 0.1355),clamp(tnoised( vec2(tCoords.x*12.0,tCoords.y*12.0)).x/2.0,0.0,1.0) );
	vec3 treeColor2 = mix(snowColor,vec3(.3921,.3921,.2863),smoothstep(0.0,0.1,h1));
	vec3 snowTree = mix(treeColor2,snowColor,smoothstep(1.1,5.5,h1));
	vec3 snowTree2 = mix(treeColor2,snowTree,clamp(tnoised( vec2(tCoords.x*16.0,tCoords.y*16.0)).x,0.0,1.0) );
	snowTree = mix(snowTree2,snowTree,smoothstep(0.0,5.5,h1));
	snowTree = mix(vec3(0.0),snowTree,smoothstep(0.0,5.5,h1));
	snowTree = mix(vec3(0.2607,0.4706,0.294),snowTree,smoothstep(0.0,1.75,h1));
	vec3 dirtColor = mix(vec3(.4227, .3529, .3412),snowTree,clamp(tnoised( vec2(tCoords.x*4.0,tCoords.y*4.0)).x/2.0,0.55,1.0) );
	
	vec3 titNoise = tnoised(tCoords.xy * 300. * h1);
	vec3 treeColor = mix(treeColor1,snowTree,smoothstep(0.0,1.0,h1)) * ( titNoise.x);
	vec3 grassColor = vec3(.27, .46, 0.25);

	vec3 landscapeColor = mix(slateColor,snowColor,smoothstep(0.0,0.9,normal.y));
	vec3 grassyTree = mix(treeColor,landscapeColor,smoothstep(1.75,5.0,h1));
	grassyTree = mix(treeColor,grassyTree,smoothstep(1.1,5.5,h1));
	landscapeColor =mix(vec3(0.1),landscapeColor,smoothstep(0.0,1.0,normal.y));
	landscapeColor =mix(dirtColor,landscapeColor,smoothstep(1.0,2.5,h1));
	landscapeColor =mix(landscapeColor,grassyTree,smoothstep(0.1,1.0,normal.y));

	float diffuseAmt = max(dot(normal, l), 0.)*(2.0/(l.y+0.5));
	vec3 diffuseColor = landscapeColor * diffuseAmt*clamp((l.y+.15)*3.5,0.02,1.0);
	diffuseColor = mix(diffuseColor,landscapeColor,clamp((l.y+.15),0.2,0.5));
	vec3 finalColor = diffuseColor;

	vec3 fogColor = getFogColor(viewPosition,lightPos,worldPosition.xyz)+(vec3(0.05,0.1,0.2));
	fogColor *= clamp(l.y*2.0,0.0,1.0);
	vec4 tempfinal =  vec4(mix(finalColor, fogColor, clamp(length(viewPosition) / maxFogDistance-(l.y), 0.0, 1.0)), 1);
	tempfinal =  vec4(mix(finalColor, fogColor, smoothstep(0.0,2.5,length(viewPosition) / maxFogDistance)),1.0);

	gl_FragColor =vec4(mix(finalColor.xyz, tempfinal.xyz, clamp(length(viewPosition) / maxFogDistance-(l.y), 0.0, 1.0)), 1);
}