#version 330 core

uniform sampler2D diffuse;
uniform sampler2D specular;
uniform sampler2D bump;
uniform sampler2D emissive;
uniform sampler2D detail;
uniform sampler2D detailbump;
uniform vec2 detailParams; // uv-scale, intensity

in vec2 pos_zw;
in vec3 normal;
in vec3 ec_pos;
in vec3 uvw;
in vec3 onorm;

#include <deferred/gbuffer_write_include.frag>

#include <deferred/tangentspace_include.frag>

vec4 weightedTexture(in sampler2D smp, in vec3 tpw, in vec3 uvw)
{
	vec4 temp = texture(smp, uvw.xy) * tpw.z;
	temp += texture(smp, uvw.yz) * tpw.x;
	temp += texture(smp, uvw.xz) * tpw.y;
	return temp;
}


vec3 weightedTextureBump(in sampler2D smp, in mat3 tsr[3], in vec3 tpw, in vec3 uvw)
{
	vec3 temp = (tsr[0] * (texture(smp, uvw.xy).xyz*2.0 - vec3(1.0))) * tpw.z;
	temp += (tsr[1] * (texture(smp, uvw.yz).xyz*2.0 - vec3(1.0))) * tpw.x;
	temp += (tsr[2] * (texture(smp, uvw.xz).xyz*2.0 - vec3(1.0))) * tpw.y;
	return temp;
}

void main()
{
	vec3 tpw = abs(normalize(onorm));
	
	vec3 baseNormal = normalize(normal);

	mat3 tsr[3];
	vec3 t, b;
	per_fragment_tangent_space(ec_pos, uvw.xy, t, b);
	tsr[0] = mat3(t, b, baseNormal);
	
	per_fragment_tangent_space(ec_pos, uvw.yz, t, b);
	tsr[1] = mat3(t, b, baseNormal);

	per_fragment_tangent_space(ec_pos, uvw.xz, t, b);
	tsr[2] = mat3(t, b, baseNormal);

	vec3 bmp = weightedTextureBump(bump, tsr, tpw, uvw).xyz;
	vec3 n = normalize(bmp);

	//vec3 deta = (texture(detail, uv*detailParams.x).rgb*2.0 - vec3(1.0)) * detailParams.y;
	vec3 deta = (weightedTexture(detail, tpw, uvw*detailParams.x).rgb*2.0 - vec3(1.0)) * detailParams.y;
	diffuse_specular.rgb = weightedTexture(diffuse, tpw, uvw).rgb + deta;
	diffuse_specular.a = weightedTexture(specular, tpw, uvw).r + deta.x;

	normal_depth.xyz = n;//mix(baseNormal, n, 0.125);
	//normal_depth.w = pos_zw.x/pos_zw.y;
	normal_depth.w = weightedTexture(emissive, tpw, uvw).r*0.5; // use this for emissive light
}
