#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;
uniform mat4 WorldMatrix;
uniform vec3 uvwScale;
uniform float time;

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;
layout (location = 4) in vec2 TEXCOORD;

out vec2 pos_zw;
out vec3 normal;
out vec3 ec_pos;
out vec3 uvw;
out vec3 onorm;

void main()
{
	float scale = abs(sin(TEXCOORD.y*3.0 - time*2.0)) * smoothstep(0.01, 0.1, TEXCOORD.y);
	vec3 offset = normalize(NORMAL) * pow(scale, 2.0) * 0.1;
	vec4 pos = vec4(POSITION + offset, 1.0);

	uvw = vec3(WorldMatrix * pos) * uvwScale;
	onorm = NORMAL;

	normal = NormalMatrix * NORMAL;
	ec_pos = vec3(ModelViewMatrix * pos);

	vec4 proj_pos = ModelViewProjectionMatrix * pos;
	pos_zw = proj_pos.zw;
	gl_Position = proj_pos;
}
