#version 430 core

uniform float lineWidth;
uniform float lineAnim;

layout(lines) in;
layout(triangle_strip, max_vertices = 6) out;

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;

in vec2 gc_tangent[2];

out vec2 pos_zw;
out vec3 normal;
out vec2 uv;

vec4 animate(in vec4 pos)
{
	vec4 center = vec4(0.0, 0.0, -1.0, 0.0);
	vec4 p0 = pos - center;
	float angle = length(p0) + (p0.x + p0.y + p0.z)*0.25;
	vec4 p1 = p0;
	p1.x += sin(p0.x*angle*3.14*8.0);
	p1.y += sin(p0.y*angle*3.14*8.0);
	return mix(p0, p1, lineAnim) + center;
}

vec4 rotate(in vec4 pos)
{
	vec4 p = pos;
	float s = sin(lineAnim*3.14);
	float c = cos(lineAnim*3.14);
	p.x = p.x*c + p.y*s;
	p.y = -p.x*s + p.y*c;
	return p;
}


#define EMIT(POS, NORM, UV) \
	normal = (NORM); \
	uv = UV; \
	pos_zw = POS.zw; \
	gl_Position = (POS); \
	EmitVertex()

void main()
{
	vec3 n = NormalMatrix * vec3(0.0, 0.0, 1.0);
	vec4 pc0 = mix(gl_in[0].gl_Position, gl_in[1].gl_Position, 0.5);
	vec4 pc1 = animate(pc0);
	vec4 p0 = gl_in[0].gl_Position;
	vec4 p1 = gl_in[1].gl_Position;
	vec4 pt = normalize(p0 - p1)*0.01;
	p0 = ModelViewProjectionMatrix * (rotate(p0+pt - pc0) + pc1);
	p1 = ModelViewProjectionMatrix * (rotate(p1-pt - pc0) + pc1);

	//vec4 t = vec4(normalize(-gc_tangent[0]) * lineWidth, 0.0, 0.0);
	vec4 t = vec4(p1.y - p0.y, p0.x - p1.x, 0.0, 0.0);
	t.xy = normalize(t.xy) * lineWidth;

	vec4 t0 = p0 + t;
	vec4 t1 = p0 - t;
	vec4 t2 = p1 + t;
	vec4 t3 = p1 - t;

	EMIT(t0, n, vec2( 1.0,  1.1));
	EMIT(t2, n, vec2( 1.0, -1.1));
	EMIT(t1, n, vec2(-1.0,  1.1));
	EndPrimitive();

	EMIT(t1, n, vec2(-1.0,  1.1));
	EMIT(t3, n, vec2(-1.0, -1.1));
	EMIT(t2, n, vec2( 1.0, -1.1));
	EndPrimitive();
}
