#version 430 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;
uniform samplerBuffer weights;
uniform samplerBuffer joints;

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;
layout (location = 4) in vec2 TEXCOORD;
layout (location = 5) in vec2 BONE_INDEX;

out vec2 pos_zw;
out vec3 normal;
out vec3 ec_pos;
out vec3 uvw;
out vec3 onorm;


vec3 rotateVector(in vec3 v, in vec4 q)
{
	vec3 uv = cross(q.xyz, v);
	vec3 uuv = cross(q.xyz, uv);
	uv *= 2.0 * q.w; 
	uuv *= 2.0;
	return v + uv + uuv;
}

void main()
{
	ivec2 weightIndexing = ivec2(BONE_INDEX);
	vec4 pos = vec4(0.0);
	vec3 norm = vec3(0.0);

	pos.w = 1.0;
	for (int i=weightIndexing.x; i < weightIndexing.y; i++)
	{
		vec4 posBias = texelFetch(weights, i*2);
		vec4 wnorm = texelFetch(weights, i*2 + 1);
		int jointID = int(wnorm.w)*2;
		vec4 jpos = texelFetch(joints, jointID);
		vec4 jori = texelFetch(joints, jointID + 1);

		vec3 rotPos = rotateVector(posBias.xyz, jori);
		pos.xyz += (jpos.xyz + rotPos) * posBias.w;

		norm += rotateVector(wnorm.xyz, jori) * posBias.w;
	}

	//pos.xyz = POSITION + pos.xyz*0.0000001;
	//norm = NORMAL + norm*0.0000001;

	uvw = POSITION*1.0;
	onorm = NORMAL;
	normal = NormalMatrix * normalize(norm);

	ec_pos = vec3(ModelViewMatrix * pos);

	vec4 proj_pos = ModelViewProjectionMatrix * pos;
	pos_zw = proj_pos.zw;
	gl_Position = proj_pos;
}
