#version 330 core

uniform sampler2D particle;
uniform sampler2D normal_depth;
uniform vec2 viewport;

in float lit;
in float blur_lod;
in vec3 wpos;

layout (location = 0) out vec4 frag_color;

#include <deferred/gbuffer_read_include.frag>

void main()
{
	vec2 uv_pos = gl_FragCoord.xy * viewport;
	float d = texture(normal_depth, uv_pos).w;
	vec3 pos = calc_position(uv_pos, d);

	if ( pos.z > wpos.z ) discard;

	vec4 part = textureLod(particle, gl_PointCoord.xy, blur_lod);
	//vec3 n = part.xyz;//*2.0 - vec3(1.0);
	//vec4 color = vec4( part.w*pow(max(dot(n, vec3(0.0, 0.0, 1.0)), 0.0), 4.0) );

	float alpha = clamp((wpos.z - pos.z)*5.0, 0.0, 1.0);

	frag_color = part * alpha * lit;
	frag_color.a = part.a;
}
