#version 430 core

uniform float time;
uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
//uniform mat4 ProjectionMatrix;

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;  // 
layout (location = 2) in vec3 COLOR;   // force
layout (location = 3) in vec3 TANGENT; // radius, energy, 1/mass

out vec3 wpos;
out float fade;

void main()
{
	vec4 pos = vec4(POSITION, 1.0);

	wpos = vec3(ModelViewMatrix * pos);
	fade = max(TANGENT.y, 0.0);

	float size = 1.0 - (length(wpos) / 128.f);
	gl_PointSize = TANGENT.x * size;
	gl_Position = ModelViewProjectionMatrix * pos;
}
