uniform vec4      CameraRange; // near, far, (far - near), (-near*far)
uniform vec4      DOFParams;   // aperture, FocalLength, PlaneInFocus, PlaneInFocus - FocalLength

float circleOfConfusion(in float z)
{
	float zz = (z - 0.5)*2.0;
	float obj_dist = CameraRange.w / (zz*CameraRange.z - CameraRange.y);
	float coc = abs( DOFParams.x * (DOFParams.y * (obj_dist - DOFParams.z)) / (obj_dist * DOFParams.w) );
	return clamp(coc, 0.0, 1.0);
}
