uniform vec3 fvLightPosition;
uniform vec3 fvEyePosition;

uniform sampler2D bumpMap;

varying vec2 Texcoord;

varying vec3 Normal;
varying vec3 LightDirection;
varying vec3 ViewDirection;

void main(void)
{
	// Check if we have a bump map attched
	if(textureSize(bumpMap, 0).x > 1)
	{
		gl_Position = ftransform();
   
		Texcoord = gl_MultiTexCoord0.xy;
		vec3 tangent;
		vec3 binormal;
   
		vec3 c1 = cross( gl_Normal, vec3(0.0, 0.0, 1.0) ); 
		vec3 c2 = cross( gl_Normal, vec3(0.0, 1.0, 0.0) ); 

		if( length(c1)>length(c2) )
		{
			tangent = c1;	
		}
		else
		{
			tangent = c2;	
		}

		tangent = normalize(tangent);

		binormal = cross(gl_Normal, tangent); 
		binormal = normalize(binormal);   
       
		vec4 objectPosition = gl_ModelViewMatrix * gl_Vertex;
 
		vec3 nNormal = gl_NormalMatrix * gl_Normal;
		vec3 nBinormal = gl_NormalMatrix * binormal;
		vec3 nTangent = gl_NormalMatrix * tangent;
   
		vec3 nLightDirection = (gl_ModelViewMatrix * vec4(fvLightPosition, 1)).xyz - objectPosition.xyz;
		//vec3 nLightDirection = fvLightPosition - objectPosition.xyz;
		vec3 nViewDirection = fvEyePosition - objectPosition.xyz;
   
		ViewDirection.x = dot(nTangent, nViewDirection);
		ViewDirection.y = dot(nBinormal, nViewDirection);   
		ViewDirection.z = dot(nNormal, nViewDirection);   
   
		LightDirection.x = dot(nTangent, nLightDirection);
		LightDirection.y = dot(nBinormal, nLightDirection);   
		LightDirection.z = dot(nNormal, nLightDirection);    
   
   
		Normal = gl_NormalMatrix * gl_Normal;
	}

	else
	{
		vec4 vertex = gl_Vertex;
		gl_Position = ftransform();
   
		Texcoord = gl_MultiTexCoord0.xy;
   
		vec4 objectPosition = gl_ModelViewMatrix * vertex;
   
		LightDirection = (gl_ModelViewMatrix * vec4(fvLightPosition, 1)).xyz - objectPosition.xyz;
		ViewDirection = fvEyePosition - objectPosition.xyz;
		Normal = gl_NormalMatrix * gl_Normal;
	}
}