#!/usr/bin/env python2
import sys
import random
import socket
from socket import timeout
import json
sys.path.append("../api/python/")
import skyport
import math

assert(len(sys.argv) == 2)

# We open the socket manually
sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
sock.connect(('127.0.0.1', 54321))

inputbuf = "" # All received data goes in here
weapons_chosen = [] # remember the weapons we chose in the loadout

def read_packet(): # this AI takes a single-thread blocking-I/O approach
    global inputbuf
    try:
        ret = sock.recv(1)
        inputbuf += ret
        if not ret:
            print("Disconnected!")
            sys.exit(1)
    except socket.timeout as e:
        print("timeout!")
        return None
    except socket.error as e:
        print("error: %s" % e)
        sys.exit(1)
    try:
        characters_to_read = inputbuf.index("\n")
        line = inputbuf[0:characters_to_read] # removing the newline
        inputbuf = inputbuf[characters_to_read+1:len(inputbuf)]
        return line
    except ValueError as f:
        return None

def do_random_move():
    direction = random.choice(["up", "down", "left-down", "left-up", "right-down", "right-up"])
    print("moving %s-wards." % direction)
    transmitter.send_move(direction)

def shoot_mortar_in_random_direction():
    # Randomly performs invalid shots.
    # [-4, 4] x [-4, 4]
    j = random.randrange(-4, 5)
    k = random.randrange(-4, 5)
    if j == 0 and k == 0:
        j = 2 # don't hit ourselves -- we don't care about bias.
        k = 2
    transmitter.attack_mortar(j, k) # coordinates relative to us

def upgrade_random_weapon():
    #transmitter.upgrade("laser")
    transmitter.upgrade(random.choice(weapons_chosen))
    
def shoot_laser_in_random_direction():
    # requires you to select the laser as weapon, obviously
    direction = random.choice(["up", "down", "left-down", "left-up", "right-down", "right-up"])
    #print("shooting %s-wards." % direction)
    transmitter.attack_laser(direction)

def shoot_droid_in_random_directions():
    directions = []
    for x in range(0, 8):
        directions.append(random.choice(["up", "down", "left-down", "left-up", "right-down", "right-up"]))
    #print("shooting droid in sequence %r" % directions)
    transmitter.attack_droid(directions)
    
def send_line(line): # sends a line to the socket
    #print("sending: '%s'" % line)
    if sock.sendall(line + "\n") != None:
        #print("Error sending data!")
        pass

def got_handshake():
    print("got handshake!")

def got_error(errmsg):
    print("Error: '%s'" % errmsg)

def got_gamestate(turn, map_obj, player_list):
    if player_list[0]["name"] == sys.argv[1]: # its our turn
        do_random_move()
        do_random_move()
        #transmitter.mine()
        random.choice([transmitter.mine, shoot_mortar_in_random_direction,
                       shoot_laser_in_random_direction, shoot_droid_in_random_directions,
                       transmitter.mine, upgrade_random_weapon])()
        
        #kart = map_obj["data"]
        # x = kart[0][0]
        me = player_list[0]["position"]
        mex = me[0]
        mey = me[1]
        
        
        
        
        

        
   

def findpath(kart, startx, starty, targetx, targety):
    openlist = []
    path = []
    #starter med starcoord i path
    start = coo()
    start.x = startx
    start.y = starty
    start.px = startx
    start.py = starty
    #Legger inn start i pathlist
    path.append(start)
    #Generer openlist

    parent = coo()
    parent.x = start.x
    parent.y = start.y
    parent.g = 0
    #I en loop med X og Y som modernode
    
    
    while goalnotfound:
        #Sjekker etter node med den minste h-verdi i openlist
        if parent.g != 0:
            min_h = 999
            for i in openlist:
                if openlist[i].h < min_h:
                    if openlist[i].check == false:
                        min_h = openlist[i].h
                        parent = openlist[i]
            # Skal naa ha retunert med en parent som har minst h-verdi

            pass
        #Tar de 8 nodene rundt, legger dem i openlist
        for i in range(0,8):
            current = coo()
            offx = returnoff(i)[0]
            offy = returnoff(i)[1]
            current.x = X + offx
            current.y = Y + offy
            #Sjekker om koordinatet allerede er i listen
            duplicate = false
            for i in openlist:
                if ((current.x == openlist[i].x) & (current.y == openlist[i].y)):
                    duplicate = true
                #MEN, hvis den nye er bedre, behold den nye.
                if current.g < openlist[i].g :
                    duplicate = false
                    del openlist[i]
            
            #Hvis det er et nytt coordinat, legg inn i liste hvis den kan ges igjennom
            if duplicate == false:
                current.px = parent.x
                current.py = parent.y
                current.type = kart[current.x][current.y]
                current.g = parent.g + 1
                current.h = mat.sqrt( pow(abs(current.x - targetx),2)+ pow(abs(current.y - targety),2))
                parent.check = true
                # Legger til current i openlist hvis man kan g? dit
                if ((current.type != "V") & (current.type !="S") & (current.type != "O")):
                    openlist.append(current)
                path.append(parent)
                # Sjekker om man er i maal
                if (current.x == targetx) & ( current.y == targety):
                    goalnotfound = false
                    print("Goal_found!!!")
                    finnishnode = current
    
    if goalnotfound == false:
        startfound = false
        path.append(finnishnode)
        n = 0

        while startfound == false:
            if ((path[n].px == start.x) & (path[n].py == start.y)):
                startfound = true
                break
                #Path found!!

            #retrace path
            for i in openlist:
                #Legger til openlist[i] hvis den samsvarer med parent-noden til path[n]
                if ((path[n].px == openlist[i].x) & (path[n].py == openlist[i].y)):
                    path.append(openlist[i])
                    n = n+1
    return path


def returnoff(i):
     if i == 0:
         offx = -1
         offy = -1
     elif i == 1:
         offx = 1
         offy = 1
     elif i == 2:
         offx = 1
         offy = -1
     elif i == 3:
         offx = -1
         offy = 1
     elif i == 4:
         offx = 1
         offy = 0
     elif i == 5:
         offx = -1
         offy = 0
     elif i == 6:
         offx = 0
         offy = -1
     elif i == 7:
         offx = 0
         offy = 1
     else:
         pass    
     return (offx, offy)


class coo:
    x = 0
    y = 0
    h = 0
    g = 0
    m = 0
    px = 0
    py  = 0
    type = ""
    check = false


def got_gamestart(turn, map_obj, player_list):
    weapons = ["mortar", "droid", "laser"]
    primary_weapon = random.choice(weapons)
    weapons.remove(primary_weapon)
    secondary_weapon = random.choice(weapons)
    # print("chose loadout: %s and %s" % (primary_weapon, secondary_weapon))
    global weapons_chosen
    weapons_chosen = [primary_weapon, secondary_weapon]
    transmitter.send_loadout(primary_weapon, secondary_weapon)
    



def got_action(action_type, who, rest_data):
    #print("got action!")
    pass

def got_endturn():
    #print("got endturn!")
    pass
    
receiver = skyport.SkyportReceiver()
transmitter = skyport.SkyportTransmitter(send_line)
# the SkyportTransmitter doesn't do networking on its own
# so you have to provide it with a send_line function that
# it can use to send data to the socket


# Register functions as callback, so that
# SkyportReceiver can call them when something happens
receiver.handler_handshake_successful = got_handshake
receiver.handler_error = got_error
receiver.handler_gamestate = got_gamestate
receiver.handler_gamestart = got_gamestart
receiver.handler_action = got_action
receiver.handler_endturn = got_endturn

# send the initial handshake
transmitter.send_handshake(sys.argv[1])

while True:
    line = read_packet() # try to read a line from the socket
    if line != None:
        # print("got line: '%r'" % line)
        receiver.parse_line(line) # hand the line to SkyportReceiver to process



    
