package aborysa.PowerShot.PathFinding;

import java.util.ArrayList;

import aborysa.PowerShot.Map.Map;

public class PathFinder {
	
	
	public static String[] findPath(Map map, int s_k, int s_j, int e_k, int e_j, int type, int max_steps){
		String[] path = findPath(map.map, map.width, s_k, s_j, e_k, e_j, type, max_steps);
		return path;
	}
	public static String[] findPath(String[] mapData, int width, int s_k, int s_j, int e_k, int e_j, int type, int max_steps){ //WORKS!, finds path
		System.out.println("Start: (" + s_k + ", " + s_j +")" + ", End: " + e_k +", " + e_j );
		String[] path = null;
		boolean foundPath = false;
		Node parrent = new Node(null, s_k + (s_j*width), 0, getDistance(s_k, s_j, e_k, e_j));
		int targetIndex = e_k + (e_j * width);
		int parrentIndex =-1;
		ArrayList<Node> openList = new ArrayList<Node>();
		ArrayList<Node> closedList = new ArrayList<Node>();
		closedList.add(parrent);
		int sycles = 0;
		while(!foundPath){
			//Get child nodes:
			sycles++;
			if (sycles >= max_steps){
				foundPath = true;
				path = null;
				System.out.println("Could not find path!");
				break;
			}
			
			int MparrentK = parrent.index % width;
			int MparrentJ = (int)Math.floor(parrent.index / width);
			int[] at = getAdjacentTiles(width,(int)mapData.length/width, MparrentK, MparrentJ); //Getting index of adjacentTiles
			//System.out.println("List size: " + mapData.length);
			for(int i =0; i< at.length;i++){ //Checking child tiles
				boolean addToOpenList = true;
				boolean addToClosedList = false;
				System.out.println("Aindex: " + at[i]);
				int k = at[i] % width; 
				int j = (int) Math.floor(at[i]/width);
				Node testNode = new Node(parrent,at[i],parrent.gValue+1,getDistance(k, j, e_k, e_j));
				if ((at[i] > mapData.length-1) || (at[i] < 0)){
				//	System.out.println("Index out of bounds!");
					continue;
				}
				if (mapData[at[i]].equals("O") || mapData[at[i]].equals("V") || mapData[at[i]].equals("S")){
					addToOpenList = false;
					addToClosedList = true;
				}
				for(int l=0; l < closedList.size();l++){
					if (closedList.get(l).index == at[i]){
					//	System.out.println("Already in closedList: " + l + "!");
						addToOpenList = false;
						addToClosedList = false;
					}
				}
				
				if(!addToClosedList){
					for(int l=0; l < openList.size();l++){
						Node tempNode = openList.get(l);
						if(tempNode.index == at[i]){
						//	System.out.println("Already in openList: " + l +"!");
							addToOpenList=false;
							if( tempNode.gValue > testNode.gValue + 1){
								tempNode.parrent = testNode;
								tempNode.gValue = testNode.gValue + 1;
							}
							break;
						}
					}
				}else{
				//	System.out.println("adding: " + testNode.index+" to closedList");
					closedList.add(testNode);
				}
				if (addToOpenList){
				//	System.out.println("Adding " + testNode.index + " to openList");
					openList.add(testNode);
				}
			}
			//End get child nodes;
			Node smallNode = null;
			for(int i = 0; i<openList.size();i++){
				Node tempNode = openList.get(i);
			
				if ( (smallNode == null) || (tempNode.getFvalue() < smallNode.getFvalue())){
					smallNode = tempNode;
					parrentIndex = i;
					
				}
			}
			if(smallNode != null){
				if(smallNode.hValue < 1){
					Node[] nodes = smallNode.traceBack(targetIndex);
					int kV[] = new int[nodes.length - 1];
					int jV[] = new int[nodes.length - 1];
					for(int i = 0; i<kV.length;i++){
						int kN = nodes[i].index % width;
						int jN = (int) Math.floor(nodes[i].index / width);
						if(nodes[i].parrent != null){
							int parrentK = nodes[i].parrent.index % width;
							int parrentJ = (int) Math.floor(nodes[i].parrent.index / width);
							kV[i] = kN - parrentK;
							jV[i] = jN - parrentJ;
							//System.out.println("K movement: " + kV[i] + ", J movement: " + jV[i]);
						}
					}
					path = moveSequence(kV,jV,type);
					System.out.println("Found path, steps: " + path.length);
					break;
				}
				parrent = smallNode;
				closedList.add(parrent);
				openList.remove(parrent);
				//System.out.println("New parrent index: " + parrent.index + ", list index: " + parrentIndex);
			}
		}
		return path;
	}

	
	public static int getDistance(int s_k,int s_j,int e_k,int e_j){
		int dist = 0;
		int deltaK = e_k - s_k;
		int deltaJ = e_j - s_j;
		int maxJK = Math.max(Math.abs(deltaK), Math.abs(deltaJ));
		if( ( (deltaK > 0) && (deltaJ >0) ) || ((deltaK < 0) && (deltaJ < 0))){
			dist = maxJK;
		}else{
			dist = Math.abs(deltaK) + Math.abs(deltaJ);
		}
		return dist;
	}
	public static String[] moveSequence(int[] k, int[] j,int type){
		String[] moveSequ = new String[j.length];
		for (int i = 0; i< j.length;i++){
			if(k[i] == j[i]){
				if(k[i] < 0){
					moveSequ[i] = "up";
				}else{
					moveSequ[i] = "down";
				}
			}else if(k[i] < 0 ){
				if (type == 1){
					moveSequ[i] = "left-up";
				}else{
					moveSequ[i] = "leftUp";
				}
			}else if(k[i] > 0){
				if(type == 1){
					moveSequ[i] = "right-down";
				}else{
					moveSequ[i] = "rightDown";
				}
			}else if(j[i] < 0){
				if(type == 1){
					moveSequ[i] = "right-up";
				}else{
					moveSequ[i] = "rightUp";
				}
			}else if(j[i] > 0){
				if (type == 1){
					moveSequ[i] = "left-down";
				}else{
					moveSequ[i] = "leftDown";
				}
			}else{
				moveSequ[i] = null;
			}
		}
		return moveSequ;
	}
	public static String[] simpleMoveSequence(int s_k, int s_j, int e_k, int e_j){
		int moveDown, moveJ, moveK = 0;
		int deltaK = e_k - s_k;
		int deltaJ = e_j - s_j;
		int minJK = Math.min(Math.abs(deltaK), Math.abs(deltaJ));
		String[] sequ = new String[minJK];
		if ( (deltaK <= 0 && deltaJ <=0) || (deltaK >= 0 && deltaJ >=0)){
			moveDown = minJK;
			if (minJK == deltaK){
				moveJ = deltaJ - deltaK;
				for(int i=0; i< moveJ;i++){
					if (moveJ < 0) sequ[i] = "right-up";
					if (moveJ > 0) sequ[i] = "left-down";
				}
			}
			else if(minJK == deltaJ){
				moveK = deltaK - deltaJ;
				for(int i=0; i< moveK;i++){
					if (moveK < 0) sequ[i] = "left-up";
					if (moveK > 0) sequ[i] = "right-down";
				}
			}
			for(int i = 0;i < moveDown;i++){
				if (minJK < 0) sequ[i] = "up";
				if (minJK > 0) sequ[i] = "down";
			}
			
			
		}else{
			moveK = deltaK;
			moveJ = deltaJ;
			for(int i=0; i< moveK;i++){
				if (moveK < 0) sequ[i] = "left-up";
				if (moveK > 0) sequ[i] = "right-down";
			}
			for(int i=0; i< moveJ;i++){
				if (moveJ < 0) sequ[i] = "right-up";
				if (moveJ > 0) sequ[i] = "left-down";
			}
		}

		return sequ;
	}
	private static int[] getAdjacentTiles(Map map, int s_k, int s_j){
		int[] parents = getAdjacentTiles(map.width,map.height,s_k, s_j);
		return parents;
	}
	private static int[] getAdjacentTiles(int width, int height, int s_k, int s_j){ 
		int[] parents= new int[6];
		int count = 0;
		for(int k =-1; k<2;k++){
			for (int j=-1;j<2;j++){
				if ( ((k >= 0 && j>=0) || (k <= 0 && j <= 0)) && !((k == 0) && (j==0))){
					if (((s_k + k) < width) && (((s_j + j)*width) +  (s_k + k)) < (width*height)){
						if(( (s_k + k)  - s_k > -2) && (((s_j + j)*width) - s_j > -2)){
							//System.out.println("TILE: " + (((s_j + j)*width) +  (s_k + k)));
							parents[count] = ((s_j + j)*width) +  (s_k + k);
							
						}else
							parents[count] = -1;
					}else{
						parents[count] = -1;
					}
					count++;
				}
				
			}
		}
		
		
		return parents;
	}
}
