/*
 * Decompiled with CFR 0.152.
 */
package net.msbone.epicbot;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.msbone.epicbot.EpicBot;
import net.msbone.epicbot.Kartet;
import net.msbone.epicbot.Loadout;
import net.msbone.epicbot.Mining;
import net.msbone.epicbot.Movement;
import net.msbone.epicbot.Players;
import net.msbone.epicbot.Weapon;

public class Client {
    private boolean connected = false;
    private BufferedReader inFromServer = null;
    private static DataOutputStream outToServer = null;
    private Socket socket = null;

    public Client(String IP, int PORT, String NAME) {
        this.connect(IP, PORT, NAME);
        this.clientLoop();
    }

    private void connect(String IP, int PORT, String NAME) {
        if (this.connected) {
            System.out.println("The client can not connect to the server. Try to restart the client/server");
        } else {
            System.out.println(String.valueOf(NAME) + " will try to join the server: " + IP + ":" + PORT);
            try {
                Socket socket = new Socket(IP, PORT);
                outToServer = new DataOutputStream(socket.getOutputStream());
                this.inFromServer = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                socket.setKeepAlive(true);
            }
            catch (UnknownHostException e) {
                System.out.println("Can not connect to the server");
                e.printStackTrace();
            }
            catch (IOException e) {
                System.out.println("Can not connect to the server");
                e.printStackTrace();
            }
            this.connected = true;
        }
    }

    public static void sendMessage(String message) {
        System.out.println("Message sent to server: " + message);
        try {
            outToServer.writeBytes(String.valueOf(message) + '\n');
            outToServer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void initstart(String NAME) {
        HashMap<String, String> connect = new HashMap<String, String>();
        connect.put("message", "connect");
        connect.put("revision", "1");
        connect.put("name", NAME);
        Gson gson = new Gson();
        String json = gson.toJson(connect);
        Client.sendMessage(json);
    }

    private void clientLoop() {
        System.out.println("Client loop startet");
        this.initstart(EpicBot.name);
        while (this.connected) {
            try {
                String data = this.inFromServer.readLine();
                if (data != null) {
                    Type type = new TypeToken<Map<String, Object>>(){}.getType();
                    Gson gson = new Gson();
                    Map map = (Map)gson.fromJson(data, type);
                    String message = null;
                    message = (String)map.get("message");
                    if (message == null) {
                        System.out.println("Error from server");
                        System.out.println(data);
                    } else if (message.equals("connect") && !this.connected) {
                        System.out.println("Server svar!");
                        if (((Boolean)map.get("status")).booleanValue()) {
                            System.out.println("We are connected to the server");
                        } else {
                            System.out.println("The server did not accept us, something is wrong");
                        }
                    } else if (message.equals("gamestate")) {
                        Double runde = (Double)map.get("turn");
                        if (runde == 0.0) {
                            Loadout.loadout(Kartet.readmap(map), Kartet.mapSize());
                            System.out.println(data);
                        } else {
                            Object[][] kart = Kartet.readmap(map);
                            Kartet kartet = new Kartet();
                            kartet.CreateWalkableArray(kart);
                            System.out.println("Rounde " + runde + " is started");
                            if (Players.isMe(map)) {
                                int posJ = Players.myPosJ(map);
                                int posK = Players.myPosK(map);
                                System.out.println(Weapon.InRange(posJ, posK, Players.closestPlayerJ(map, posJ, posK), Players.closestPlayerK(map, posJ, posK), "laser", kart));
                                System.out.println(Weapon.InRange(posJ, posK, Players.closestPlayerJ(map, posJ, posK), Players.closestPlayerK(map, posJ, posK), "mortar", kart));
                                Random generator = new Random();
                                Movement movement = new Movement();
                                System.out.println(Mining.closestMineRange("R", posJ, posK));
                                int goalj = Players.closestPlayerJ(map, posJ, posK);
                                int goalk = Players.closestPlayerK(map, posJ, posK);
                                String[] moves = movement.path(posJ, posK, goalj, goalk, 0);
                                int i = 0;
                                while (i < 3) {
                                    HashMap<String, String> moveMessage = new HashMap<String, String>();
                                    moveMessage.put("message", "action");
                                    moveMessage.put("type", "move");
                                    moveMessage.put("direction", moves[i]);
                                    String json = gson.toJson(moveMessage);
                                    Client.sendMessage(json);
                                    ++i;
                                }
                                String move_echo = "moves: ";
                                int imove = 0;
                                while (imove < moves.length) {
                                    move_echo = String.valueOf(move_echo) + moves[imove] + " ";
                                    ++imove;
                                }
                                System.out.println("our_pos: (" + posJ + "," + posK + ")");
                                System.out.println("goal: (" + goalj + "," + goalk + ")");
                                System.out.println(move_echo);
                            }
                        }
                    } else if (!message.equals("endturn") && !message.equals("action")) {
                        System.out.println("Ukjent data motatt fra server " + data);
                    }
                }
                Thread.sleep(200L);
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
                try {
                    this.socket.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }
}

