#include <stdlib.h>

#include "bfs.h"
#include "main.h"
#include "map.h"

typedef struct queue_entry {
    int coords;
    struct queue_entry *next;
} queue_entry_t;

void bfs(int start_coords, int *camefrom, int pass_everything,
    search_callback_t callback, void *callback_state)
{
    /* Initialize the camefrom values to -1. */
    for (int i = 0; i < map_size; i++) {
        camefrom[i] = -1;
    }

    /* Set up the BFS queue. */
    queue_entry_t *head = malloc(sizeof(queue_entry_t));
    head->coords = start_coords;
    head->next = 0;

    queue_entry_t **next_ptr = &head->next;

    while (1) {
        /* Terminate if the queue is empty. */
        if (head == 0) {
            //debug("BFS queue is empty\n");
            break;
        }

        /* Get coords for queue head. */
        int coords = head->coords;
        int j = map_j_val(coords), k = map_k_val(coords);
        //debug("Queue head is coords %d j %d k %d\n", coords, j, k);

        /* Iterate over neighbors.*/
        int js[6], ks[6];
        js[0] = j + 1; ks[0] = k + 0;
        js[1] = j - 1; ks[1] = k + 0;
        js[2] = j + 0; ks[2] = k + 1;
        js[3] = j + 0; ks[3] = k - 1;
        js[4] = j + 1; ks[4] = k + 1;
        js[5] = j - 1; ks[5] = k - 1;
        for (int i = 0; i < 6; i++) {
            //debug("Considering neighbor j %d k %d\n", js[i], ks[i]);

            /* Skip if out of bounds. */
            if (js[i] < 0 || js[i] >= map_j ||
                ks[i] < 0 || ks[i] >= map_k) {
                //debug("Out of bounds\n");
                continue;
            }

            /* Skip if already visited. */
            int neigh_coords = map_coords(js[i], ks[i]);
            if (camefrom[neigh_coords] != -1) {
                //debug("Already visited\n");
                continue;
            }

            /* Skip if nontraversable. */
            char cell = map_get(js[i], ks[i]);
            if (!pass_everything &&
                (cell == 'V' || cell == 'S' || cell == 'O')) {
                //debug("Not traversable\n");
                continue;
            }

            /* Set visited. */
            camefrom[neigh_coords] = coords;

            /* Append to queue. */
            queue_entry_t *entry = malloc(sizeof(queue_entry_t));
            (*next_ptr) = entry;
            next_ptr = &entry->next;
            entry->coords = neigh_coords;
            entry->next = 0;

            //debug("Adding to queue\n");
        }

        /* Remove from queue. */
        queue_entry_t *old_head = head;
        head = head->next;
        free(old_head);

        /* Invoke callback. */
        int result = (*callback)(coords, camefrom, callback_state);

        /* If callback returned 1, stop the BFS. */
        if (result == 1) {
            while (head != 0) {
                queue_entry_t *old_head = head;
                head = head->next;
                free(old_head);
            }
            return;
        }
    }
}
