AssetParameter = {}
AssetParameter_mt = { __index = AssetParameter }
setmetatable(AssetParameter, Control_mt)

-- Constants
AssetParameter.kHeight = 30
AssetParameter.kWidth = 400
AssetParameter.valueOutline = ParameterList.kValueOutlineBig

function AssetParameter.Create(root, parentObject, type, index, parameter, node, onChange)
	-- Create object
	local assetParameter = Control.Create(root, parentObject)
	setmetatable(assetParameter, AssetParameter_mt)
	
	-- Set attributes
	assetParameter.value = 'browse for file...'
	assetParameter.type = type
	assetParameter.onChange = onChange

	-- Create parameter value surfaces
	assetParameter.valueSurface = GSurface(AssetParameter.kWidth, AssetParameter.kHeight)
	assetParameter:UpdateValueSurface()
	
	return assetParameter	
end
	
function AssetParameter:HandleEvent(window, rect, event)
	window:PushScissor(rect)
		local rect = window.currentScissor
		
		local isHot = rect:IsPointInside(event.pos) and not self:IsOtherControlActive()
		
		if (self.isActive==false) then
			if (event.type==kGEventMouseMoved) then
				self:SetHot(isHot)
			elseif (event.type==kGEventMouseDown) then
				if (event.button==kGEventMouseButtonLeft) then
					if (self.isHot) then
						-- spawn load file dialog
						if (intruder.SpawnLoadFileDialog()==intruder.kDialogFileChosen) then
							local i = string.find(intruder.DialogResult():lower(), intruder.g_pszProjectDirectory:lower(), 1, true)
							if (i~=1) then
								print("Source file was not inside project directory")
							else
								local relString = intruder.DialogResult():sub(intruder.g_pszProjectDirectory:len()+1)
								self.value = relString
								self:UpdateValueSurface()
								
								if (self.onChange) then
									self.onChange(relString)
								end
							end
						end
					end
				end
			end
		end
	window:PopScissor()
end

function AssetParameter:Draw(window, rect)
	window:PushScissor(rect)
		self.valueSurface:DrawTexture(rect:GetTopLeft())
		
		if (self.isHot) then
			self.valueOutline:DrawTexture(rect:GetTopLeft())
		end
	window:PopScissor()
end

function AssetParameter:UpdateValueSurface()
	local str = self.value
	local surface = self.valueSurface
	surface:Clear(GColor(0, 0, 0, 0))
	surface:DrawTextAligned(intruder.kFontFaceEnvyBold, str, GColor(0, 0, 0), 13, kGAlignCenter, kGVerticalAlignCenter, GPoint(1,1));
	surface:DrawTextAligned(intruder.kFontFaceEnvyBold, str, GColor(255, 255, 255), 13, kGAlignCenter, kGVerticalAlignCenter, GPoint(0,0));
	surface:UpdateTexture()
end
