#version 150

out vec4 fragColor;

uniform sampler2D layer1; // Sky
uniform sampler2D layer2; // Terrain
uniform sampler2D glow; // glow

in vec2 uv;

vec4 screen(vec4 color0, vec4 color1)
{
    vec4 white = vec4(1.0, 1.0, 1.0, 1.0);
    return white - ((white - color0) * (white - color1));
}

void main()
{
    vec4 c1 = texture(layer1, uv);
    vec4 c2 = texture(layer2, uv);
    vec4 g = texture(glow, uv);
	fragColor = screen(mix(c1, c2, c2.a), g);
}
