#version 150

uniform sampler2D background_image;
uniform sampler2D text_image;
uniform float bgxpos;
uniform float bgypos;
uniform float bgzoom;
uniform float fgxpos;
uniform float fgypos;
uniform float fgzoom;

in vec2 uv;

out vec4 fragColor;


vec3 screen(vec3 color0, vec3 color1)
{
    vec3 white = vec3(1.0);
    return white - ((white - color0) * (white - color1));
}

void main()
{
    vec4 c1 = texture(background_image, vec2(uv.x+bgxpos, uv.y+bgypos)/bgzoom);
    vec4 c2 = texture(text_image, vec2(uv.x+fgxpos, uv.y+fgypos)/fgzoom);
    fragColor =  vec4(screen(c1.rgb, c2.rgb), 0.0);
}
