#version 150 core

out vec4 fragColor;
uniform sampler2D background;
uniform vec2 screen;

in vec4 color;
in float fade;

float getDepth()
{
    float z = gl_FragCoord.z;
    float n = 0.1;
    float f = 500;
    float depth = (2.0 * n) / (f + n - z * (f - n));
    return 1.0 - depth;
}

void main()
{
    vec4 bg = texture(background, gl_FragCoord.xy / screen);
    float depth = getDepth();
    fragColor = mix(bg, color * depth, fade);
}