#version 120

uniform float effecttime;
uniform float fadein;
varying vec2 texturecoordinate;

void main(void)
{
	float y = texturecoordinate.y;
	
	float p1 = 0.5 + 0.5 * sin(y*51 + effecttime * 275);
	float p2 = 0.5 + 0.5 * cos(y*14 + effecttime * 391);
	float p3 = 0.5 + 0.5 * sin(0.7+y*21 + effecttime * 775);
	
	float s = (p1 + p2 + p3) * 0.333;
	
	vec4 color1 = vec4(1.0, 1.0, 1.0, 1.0);
	vec4 color2 = vec4(0.4, 0.5, 1.0, 1.0);
	
	vec4 fin = mix(color1, color2, s) * fadein;
	
	gl_FragColor = fin;
}