//flat shading
//
//input:
//
//	gl_LightSource[0].position = light direction
//  gl_LightSource[0].diffuse = light color
//	gl_LightSource[0].ambient = ambient color
//  gl_FrontMaterial.diffuse = material color
//

//lighted up pixel color that goes to the fragment shader

uniform float scenerotation;
uniform float scenemorph;

varying vec4 diffuse;
varying vec4 ambient;

//different vectors needed for lighting in the fragment shader
varying vec3 halfvector;
varying vec3 lightdirection;
varying vec3 normal;

void main(void)
{
	normal = normalize(gl_NormalMatrix * gl_Normal);
	lightdirection = normalize(vec3(gl_LightSource[0].position));
	halfvector = normalize(gl_LightSource[0].halfVector.xyz);	

	//calculate colors from both the light and the material
	diffuse = gl_FrontMaterial.diffuse * gl_LightSource[0].diffuse;
	ambient = gl_FrontMaterial.ambient * gl_LightSource[0].ambient;
	
	float a = gl_Vertex.x;
	float b = gl_Vertex.y;
	float c = gl_Vertex.z;
	
	vec4 npos = normalize(gl_Vertex);
	
//	a /= npos.x;
//	b /= npos.y;
//	c *= npos.y;
	
	float x = (sin(a)*sin(b) * c);
	float y = (sin(a)*cos(b) * c);
	float z = (cos(a) * c);
	
	vec4 vs = vec4(x, y, z, gl_Vertex.w);
	vec4 vn = vec4(gl_Vertex.x, gl_Vertex.y, gl_Vertex.z, gl_Vertex.w);
	
	float bx = scenemorph;
	float by = scenemorph;
	float bz = scenemorph;
	float bw = scenemorph;
	vec4 vert = mix(vs, vn, vec4(bx, by, bz, bw));
	
	gl_Position = gl_ModelViewProjectionMatrix * vert;
}