#version 120

uniform sampler2D sourcetexture1;
uniform sampler2D sourcetexture2;

uniform float blend_t;
varying vec2 texturecoordinate;

void main(void)
{
	vec4 texel1 = texture2D(sourcetexture1, texturecoordinate);
	vec4 texel2 = texture2D(sourcetexture2, texturecoordinate);
	
	vec4 finalcolor = mix(texel1, texel2, blend_t);
	
	vec4 fc = mix(vec4(1.0, 1.0, 1.0, 1.0), finalcolor, 0.15);
	
	gl_FragColor = fc;
}