#version 330 core

uniform sampler2D volume;
uniform sampler2D shape;
uniform sampler2D normal_depth;
uniform vec2 viewport;

in vec3 uv_shade;
in vec3 wpos;

layout (location = 0) out vec4 frag_color;

#include <deferred/gbuffer_read_include.frag>

void main()
{
	vec2 uv_pos = gl_FragCoord.xy * viewport;
	float d = texture(normal_depth, uv_pos).w;
	vec3 pos = calc_position(uv_pos, d);

	if ( pos.z > wpos.z ) discard;

	float alpha = min(0.25, clamp((wpos.z - pos.z)*(1.0/8.0), 0.0, 1.0));

	frag_color = texture(volume, uv_shade.xy) * texture(shape, uv_shade.xy) * uv_shade.z * alpha;
	frag_color.a = 0.0;
}
