#version 410 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;
uniform samplerBuffer instanceData;

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;
layout (location = 4) in vec2 TEXCOORD;

out vec2 pos_zw;
out vec3 normal;
out vec3 ec_pos;
out vec2 uv;

#include <go1891/pinhead_transform_include.vert>

void main()
{
	mat4 mt;
	mt[0] = texelFetch(instanceData, gl_InstanceID*4 + 0);
	mt[1] = texelFetch(instanceData, gl_InstanceID*4 + 1);
	mt[2] = texelFetch(instanceData, gl_InstanceID*4 + 2);
	mt[3] = texelFetch(instanceData, gl_InstanceID*4 + 3);

	mat3 mn;
	mn[0] = mt[0].xyz;
	mn[1] = mt[1].xyz;
	mn[2] = mt[2].xyz;

	vec4 pos = mt * vec4(POSITION, 1.0);
	vec3 displace;
	PinHeadDisplace(pos.xyz, pos, displace);

	uv = TEXCOORD;
	normal = NormalMatrix * (mn * NORMAL);

	ec_pos = vec3(ModelViewMatrix * pos);

	vec4 proj_pos = ModelViewProjectionMatrix * pos;
	pos_zw = proj_pos.zw;
	gl_Position = proj_pos;
}
