#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;
uniform samplerBuffer instanceData;

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;
layout (location = 4) in vec2 TEXCOORD;

out vec2 pos_zw;
out vec3 normal;
out vec3 ec_pos;
out vec2 uv;


vec4 fromCylindical(in vec2 coord)
{
	vec4 pos;
	float theta = 3.1415 * (coord.x / 6.0) + coord.y;
	//float radius = pow(1.0 / (coord.y + 4.0), 2.0) * 8.0;
	float k = 1.0 / (coord.y + 4.0);
	float radius = pow(k - 0.7 + 0.3*sin(k), 2.0) * 8.0;
	pos.w = (1.0 / (coord.y + 4.1)) * 4.0;
	pos.x = radius * cos(theta);
	pos.z = radius * sin(theta);
	pos.y = coord.y - 4.0;
	return pos;
}


void main()
{
	//vec4 instPos = fromCylindical(texelFetch(instanceData, gl_InstanceID).xy);
	vec4 instPos = texelFetch(instanceData, gl_InstanceID).xzyw;

	vec3 pos = POSITION*instPos.w*(1.0/24.0) + instPos.xyz;

	uv = TEXCOORD;
	normal = NormalMatrix * NORMAL;

	ec_pos = vec3(ModelViewMatrix * vec4(pos, 1.0));

	vec4 proj_pos = ModelViewProjectionMatrix * vec4(pos, 1.0);
	pos_zw = proj_pos.zw;
	gl_Position = proj_pos;
}
