OPT	SIMPLE

MODULE	'exec/memory'

CONST	WIDTH=80,
		HEIGHT=40,
		STP=4

PROC main()
	DEF	bm
	DEF	a,da,c,n,dc,b,db
	DEF	bm1:PTR TO d_bitmap,bm2,bm3,bm4,bm5,bm6,bm7,bm8,bm9,bm10
	bm1:=LoadBM('gfx/amiga_logo.jpg')
	bm2:=ScaleBM(bm1,300,40)
	bm3:=CreateBM(WIDTH,HEIGHT,DBMT_Gray)
	bm4:=LoadBin('gfx/demo_butt1.bin')
	bm5:=LoadBM('gfx/boingball.jpg')
	bm6:=ScaleBM(bm5,30,20)
	bm7:=ScaleBM(bm5,120,80)
	bm8:=LoadBM('gfx/costume.png')
	bm9:=LoadBM('gfx/credits.png')
	bm10:=LoadBin('gfx/demo_bajmark.bin')

	IF bm1=NIL OR bm2=NIL OR bm3=NIL OR bm4=NIL OR bm5=NIL OR bm6=NIL OR bm7=NIL OR bm8=NIL OR bm9=NIL OR bm10=NIL
		PrintF('sorry can''t load gfx data!\n')
		Raise()
	ENDIF

	IF bm:=CreateBM(WIDTH,HEIGHT,DBMT_Gray)
		SetBM(bm,$ffffff)

		WriteStr('\j012')
		WriteStr('ascii demo for Resetkani 2013 (4.5.2013)\n\n')

		WriteStr('please wait while loading music\n')
		WriteStr('..........\n',10)
		WriteStr('FAILED: sorry, no music this time.\n\n')
		WriteStr('please wait while loading graphics\n')
		WriteStr('..........\n',10)
		WriteStr('FAILED: sorry, no graphics this time.\n\n')
		WriteStr('determining memory requirements\n')
		WriteStr('..........\n',30)
		WriteStr('FAILED: sorry, for superb hd effects you need more ram.\n\n')
		WriteStr('testing cpu speed for optimal realtime playback\n')
		WriteStr('..........\n',40)
		WriteStr('FAILED: sorry, Your cpu isn''t capable of such hitech demonstration.\n\n')
		WriteStr('ok... after all, Your machine is able to execute\nthis demo with a bit reduced graphic details\n\n')
		WriteStr('please wait while initialising\n')
		WriteStr('..........\n',30)

		WriteStr('ok, let''s go!\n')
		WriteStr('\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n',4)
		WriteStr('\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n',3)
		WriteStr('\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n',2)
		WriteStr('\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n',1)

/*
		a:=0
		da:=1
		FOR n:=0 TO 200
			SetBM(bm,$ffffff)
			Blur(bm,4)
//			Invert(bm)
			DrawLine(bm,0,a,WIDTH-1,a,0,1)
//			Invert(bm)
			a+=da
			IF a>=HEIGHT OR a<0 THEN da:=-da
			PAscii(bm)
		EXITIF CtrlC()
		ENDFOR
*/

		// frame effect
		FOR n:=0 TO 19
			SetBM(bm,$ffffff)
			DrawFrame(bm,n,1,0)
			PAscii(bm)
			Delay(1)
		EXITIF CtrlC()
		ENDFOR

		FOR n:=19 DTO 0
			DrawFrame(bm,n,1,0)
			PAscii(bm)
			Delay(1)
		EXITIF CtrlC()
		ENDFOR

		FOR n:=19 DTO 2
			SetBM(bm,$ffffff)
			DrawFrame(bm,0,n,0)
			PAscii(bm)
			Delay(1)
		EXITIF CtrlC()
		ENDFOR

		// amiga logo with frame
		FOR n:=WIDTH-1 DTO -300 STEP -2
			CopyBM(bm,bm2,n,0)
			DrawFrame(bm,0,2,0)
			PAscii(bm)
		EXITIF CtrlC()
		ENDFOR

		// fading frame
		FOR n:=0 TO 255 STEP 8
			DrawFrame(bm,0,2,n)
			PAscii(bm)
		EXITIF CtrlC()
		ENDFOR

		// amiga logo backwards
		FOR n:=-300 TO WIDTH STEP 2
			CopyBM(bm,bm2,n,0)
			PAscii(bm)
		EXITIF CtrlC()
		ENDFOR

		// cube fade in
		a:=0
		SubsIn('rotating CUBE with several effects')
		FOR n:=0 TO 255 STEP 4
			SetBM(bm,0)
			Draw3D(bm,10,10,10,0.2,a/64.1,a/32.1,30,n,"CUBE")
			Invert(bm)
			PAscii(bm)
			Invert(bm)
			a++
		EXITIF CtrlC()
		ENDFOR

		// cube blur in
		FOR n:=0 TO 255 STEP 4
			Blur(bm,n/32)
			c:=255	//j*4
			Draw3D(bm,10,10,10,0.2,a/64.1,a/32.1,30,c,"CUBE")
			Invert(bm)
			PAscii(bm)
			Invert(bm)
			a++
		EXITIF CtrlC()
		ENDFOR

		// cube blur, resize
		FOR n:=0 TO 360 STEP 4
			Blur(bm,8)
			c:=255	//j*4
			Draw3D(bm,10,10+5*Sin(n*PI/180),10,0.2,a/64.1,a/32.1,30,c,"CUBE")
			Invert(bm)
			PAscii(bm)
			Invert(bm)
			a++
		EXITIF CtrlC()
		ENDFOR

		// cube blur out
		FOR n:=0 TO 255 STEP 4
			Blur(bm,(255-n)/32)
			c:=255	//j*4
			Draw3D(bm,10,10,10,0.2,a/64.1,a/32.1,30,c,"CUBE")
			Invert(bm)
			PAscii(bm)
			Invert(bm)
			a++
		EXITIF CtrlC()
		ENDFOR

		// cube and shaded amiga logo
		FOR n:=WIDTH-1 DTO -300 STEP -4
			SetBM(bm3,$ffffff)
			CopyBM(bm3,bm2,n,0)
			Fade(bm,bm3,255,128)
			Invert(bm)
			Draw3D(bm,10,10,10,0.2,a/64.1,a/32.1,30,255,"CUBE")
			Invert(bm)
			PAscii(bm)
			a++
		EXITIF CtrlC()
		ENDFOR

		// cube, picture fade in
		FOR n:=0 TO 255 STEP 4
			SetBM(bm,$ffffff)
			Fade(bm,bm4,255,n)
			Draw3D(bm,10,10,10,0.2,a/64.1,a/32.1,30,0,"CUBE","H")
			PAscii(bm)
			a++
		EXITIF CtrlC()
		ENDFOR

		SubsOut()
		// cube leave down, picture
		FOR n:=0 TO 255 STEP 4
			SetBM(bm,$ffffff)
			Fade(bm,bm4,255,255)
			Draw3D(bm,10,10,10,0.2,a/64.1,a/32.1,30,0,"CUBE","H",n/6)
			PAscii(bm)
			a++
		EXITIF CtrlC()
		ENDFOR

		// picture fade out
		FOR n:=0 TO 255 STEP 4
			SetBM(bm,$ffffff)
			Fade(bm,bm4,255,255-n)
			PAscii(bm)
		EXITIF CtrlC()
		ENDFOR

		// jumping boing ball
		SubsIn('jumping boing ball')
		FOR n:=-30 TO WIDTH
			SetBM(bm,$ffffff)
			CopyBM(bm,bm6,n,HEIGHT-20-20*FAbs(Sin((n+10)/10)))
			PAscii(bm)
//			Delay(1)
		EXITIF CtrlC()
			IF n=WIDTH-20 THEN SubsOut()
		ENDFOR

		// moving boing ball
		SubsIn('moving maxi boing ball')
		FOR n:=0 TO 360
			SetBM(bm,$ffffff)
			a:=60*Sin(n*PI/180)
			b:=40*Cos(n*PI/180)
			CopyBM(bm,bm7,a,b)
			PAscii(bm)
//			Delay(1)
		EXITIF CtrlC()
			IF n=320 THEN SubsOut()
		ENDFOR

		// moving woman
		SubsIn('moving woman')
		FOR n:=-140 TO HEIGHT
			CopyBM(bm,bm8,0,n)
			PAscii(bm)
		EXITIF CtrlC()
			IF n=0 THEN SubsOut()
		ENDFOR

		SubsIn('and credits means we are reaching the end')
		FOR n:=HEIGHT DTO -330
			CopyBM(bm,bm9,0,n)
			PAscii(bm)
		EXITIF CtrlC()
			IF n=-280 THEN SubsOut()
		ENDFOR
		Delay(100)

		CopyBM(bm3,bm9,0,n+1)
		FOR n:=0 TO 255 STEP 8
			Spread(bm,bm10,bm3,n)
			PAscii(bm)
		EXITIF CtrlC()
		ENDFOR

/*
		GradV(bm,0,255)
		a:=0
		c:=0
		FOR n:=0 TO WIDTH-1
			c:=n*255/WIDTH
			DrawLine(bm,0,0,n,HEIGHT-1,c,"H")
			DrawLine(bm,WIDTH-1,HEIGHT-1,WIDTH-1-n,0,c,"H")
			PAscii(bm)
		EXITIF CtrlC()
		ENDFOR
		FOR n:=WIDTH-1 DTO -300 STEP -2
			CopyBM(bm,bm2,n,0)
			DrawFrame(bm,2,2,128)
			PAscii(bm)
		EXITIF CtrlC()
		ENDFOR
*/

		DeleteBM(bm)
	ENDIF
EXCEPTDO
	IF bm9 THEN DeleteBM(bm9)
	IF bm8 THEN DeleteBM(bm8)
	IF bm7 THEN DeleteBM(bm7)
	IF bm6 THEN DeleteBM(bm6)
	IF bm5 THEN DeleteBM(bm5)
	IF bm4 THEN DeleteBM(bm4)
	IF bm3 THEN DeleteBM(bm3)
	IF bm2 THEN DeleteBM(bm2)
	IF bm1 THEN DeleteBM(bm1)
ENDPROC

PROC WriteStr(chars:PTR TO CHAR,delay=5)
	DEF	pos=0,stdout
	stdout:=Output()
	WHILE chars[pos]
		Delay(delay)
		Write(stdout,chars+pos,1)
		pos++
	ENDWHILE
ENDPROC

DEF	subs:PTR TO CHAR,
		show,					// -1=in, 0=stable, 1=out
		act=0

// print ascii
PROC PAscii(bm:PTR TO d_bitmap)
	DEF	table=' .:,-;"^|(T?<uf{UCKAGOQB&%mM#$B@':PTR TO CHAR,tabmax=16
	DEF	buffer[(WIDTH+1)*HEIGHT]:UB,n=0,m=0,x,y,data:PTR TO UB,stdout
	data:=bm.data
	FOR y:=0 TO bm.he-1
		FOR x:=0 TO bm.wi-1
			buffer[n++]:=table[31-(data[m++]>>3)]
		ENDFOR
		buffer[n++]:="\n"
	ENDFOR

	// subtitles
	IF subs
		DEF	len
		len:=StrLen(subs)
		SELECT show
		CASE -1
			act++
			IF act=len THEN show:=0	// done display stable
			len:=Min(len,act)
		CASE 1
			act--
			IF act=0 THEN subs:=NIL	// done display nothing
			len:=Min(len,act)
		DEFAULT
		ENDSELECT
		n:=0
		WHILE n<len
			buffer[(WIDTH+1)*(HEIGHT-1)-len-1+n]:=subs[n]
//			buffer[n]:=subs[n]
			n++
		ENDWHILE
	ENDIF

	stdout:=Output()
	Write(stdout,'\j012',1)
	Write(stdout,buffer,(bm.wi+1)*bm.he)
	Delay(1)
ENDPROC

PROC SubsIn(txt:PTR TO CHAR)
	subs:=txt
	show:=-1
	act:=0
ENDPROC

PROC SubsOut()
	show:=1
	act:=StrLen(subs)
ENDPROC

PROC GradV(bm:PTR TO d_bitmap,a,b)
	DEF	x,y,n=0,i,data:PTR TO UB
	data:=bm.data
	FOR y:=0 TO bm.he-1
		i:=(bm.he-y)*b/bm.he+y*a/bm.he
		FOR x:=0 TO bm.wi-1
			data[n++]:=i
		ENDFOR
	ENDFOR
ENDPROC

PROC GradH(bm:PTR TO d_bitmap,a,b)
	DEF	x,y,n=0,i,data:PTR TO UB
	data:=bm.data
	FOR x:=0 TO bm.wi-1
		i:=(bm.wi-x)*b/bm.wi+x*a/bm.wi
		FOR y:=0 TO bm.he-1
			data[x+y*bm.wi]:=i
		ENDFOR
	ENDFOR
ENDPROC

PROC DrawLine(bm:PTR TO d_bitmap,x1:F,y1:F,x2:F,y2:F,c,hard="S")
	DEFD	hl=FAbs(x2-x1),vl=FAbs(y2-y1)
	DEFD	length=IF hl>vl THEN hl ELSE vl
	DEFF	deltax=(x2-x1)/length,deltay=(y2-y1)/length
	DEF	i=0,data:PTR TO UB
	data:=bm.data
	WHILE i<length
		DEFUL	x=x1+=deltax,y=y1+=deltay
		IF x<bm.wi&&y<bm.he&&x>=0&&y>=0
			IF hard="S"
				IF data[x+y*bm.wi]+c>=255
					data[x+y*bm.wi]:=255
				ELSE
					data[x+y*bm.wi]+=c
				ENDIF
			ELSE
				data[x+y*bm.wi]:=c
			ENDIF
		ENDIF
		i++
	ENDWHILE
ENDPROC

PROC Fade(dst:PTR TO d_bitmap,bm:PTR TO d_bitmap,c,i)
	DEF	n=WIDTH*HEIGHT,dd:PTR TO UB,sd:PTR TO UB
	dd:=dst.data
	sd:=bm.data
	WHILE n
		n--
		dd[n]:=sd[n]*i/255+c*(255-i)/255
	ENDWHILE
ENDPROC

PROC FadeSide(dst:PTR TO d_bitmap,bma:PTR TO d_bitmap,bmb:PTR TO d_bitmap,s,f)
	DEF	i,x
	FOR x:=0 TO dst.wi-1
		IF x<s
			i:=255
		ELSEIF x>f
			i:=0
		ELSE
			i:=255-255*(x-s)/(f-s)
		ENDIF
		FadeVLine(dst,bma,bmb,x,i)
	ENDFOR
ENDPROC

PROC FadeVLine(dst:PTR TO d_bitmap,bma:PTR TO d_bitmap,bmb:PTR TO d_bitmap,x,i)
	DEF	n,dd:PTR TO UB,sa:PTR TO UB,sb:PTR TO UB
	dd:=dst.data
	sa:=bma.data
	sb:=bmb.data
	FOR n:=0 TO dst.he-1
		dd[x+n*WIDTH]:=sb[x+n*dst.wi]*i/255+sa[x+n*dst.wi]*(255-i)/255
	ENDFOR
ENDPROC

PROC Blur(bm:PTR TO d_bitmap,i)
	DEF	n,data:PTR TO UB
	data:=bm.data
	n:=bm.wi*bm.he
	WHILE n
		n--
		data[n]:=i*data[n]/(i+1)
	ENDWHILE
ENDPROC

PROC Invert(bm:PTR TO d_bitmap)
	DEF	n,data:PTR TO UB
	data:=bm.data
	n:=bm.wi*bm.he
	WHILE n
		n--
		data[n]:=255-data[n]
	ENDWHILE
ENDPROC

PROC Spread(bm:PTR TO d_bitmap,bm1:PTR TO d_bitmap,bm2:PTR TO d_bitmap,i)
	DEF	n,dd:PTR TO UB,sa:PTR TO UB,sb:PTR TO UB
	dd:=bm.data
	sa:=bm1.data
	sb:=bm2.data
	n:=bm.wi*bm.he
	WHILE n
		n--
		dd[n]:=sa[n]*i/255+sb[n]*(255-i)/255
	ENDWHILE
ENDPROC

PROC DrawFrame(bm:PTR TO d_bitmap,dist,size,col)
	DEF	n
	FOR n:=0 TO size-1
		DrawLine(bm,dist+n,dist+n,bm.wi-1-dist-n,dist+n,col,col)
		DrawLine(bm,bm.wi-1-dist-n,dist,bm.wi-1-dist-n,bm.he-1-dist-n,col,col)
		DrawLine(bm,bm.wi-1-dist-n,bm.he-1-dist-n,dist+n,bm.he-1-dist-n,col,col)
		DrawLine(bm,dist+n,bm.he-1-dist-n,dist+n,dist+n,col,col)
	ENDFOR
ENDPROC

PROC LoadBin(name,offset=0)(PTR TO d_bitmap)
	DEF	bm:PTR TO d_bitmap,fi,data:PTR TO UB
	IF bm:=CreateBM(WIDTH,HEIGHT,DBMT_Gray)
		IF fi:=Open(name,OLDFILE)
			Read(fi,bm.data,offset)
			Read(fi,bm.data,WIDTH*HEIGHT)
			DEF	n
			n:=WIDTH*HEIGHT
			data:=bm.data
			WHILE n
				n--
				data[n]:=255-data[n]
			ENDWHILE
			Close(fi)
		ENDIF
	ENDIF
ENDPROC bm

/*
PROC main()
	DEF	bm,n,c,bmx,bmy,bmt,bmg,bmb,bma,bmm,a
	IF bm:=new()
//		gradh(bm,0,255)
//		pa(bm)
/*
		n:=255
		WHILE n
			clear(bm,n)
			pa(bm)
			n--
		ENDWHILE
*/
/*
		FOR n:=0 TO 255 STEP STP
			gradv(bm,0,n)
			pa(bm)
		ENDFOR
		FOR n:=0 TO 255 STEP STP
			gradv(bm,n,255)
			pa(bm)
		ENDFOR
		FOR n:=255 DTO 0 STEP -STP
			gradh(bm,255,n)
			pa(bm)
		ENDFOR
		FOR n:=255 DTO 0 STEP -STP
			gradh(bm,n,0)
			pa(bm)
		ENDFOR
*/
		clear(bm,0)

		IF bmx:=load('gfx/demo_xicht3.bin')
		IF bmy:=load('gfx/demo_xicht4.bin')
		IF bmg:=load('gfx/demo_girl1.bin')
		IF bmb:=load('gfx/demo_butt1.bin')
		IF bmt:=load('gfx/demo_tits1.bin')
		IF bma:=load('gfx/demo_artway.bin')
		IF bmm:=load('gfx/demo_bajmark.bin')
			a:=0
			c:=0
			FOR n:=0 TO WIDTH-1
				c:=n*255/WIDTH
				drawline(bm,0,0,n,HEIGHT-1,c,"H")
				drawline(bm,WIDTH-1,HEIGHT-1,WIDTH-1-n,0,c,"H")
				pa(bm)
			EXITIF CtrlC()
			ENDFOR
			FOR n:=0 TO HEIGHT-1
				c:=(HEIGHT-n)*255/HEIGHT
				drawline(bm,0,n,WIDTH-1,HEIGHT-1,c,"H")
				drawline(bm,0,0,WIDTH-1,HEIGHT-1-n,c,"H")
				pa(bm)
			EXITIF CtrlC()
			ENDFOR
			FOR n:=0 TO HEIGHT-1
				c:=(HEIGHT-n)*255/HEIGHT
				drawline(bm,WIDTH-1,0,0,n,0,"H")
				drawline(bm,0,HEIGHT-1,WIDTH-1,HEIGHT-1-n,0,"H")
				pa(bm)
			EXITIF CtrlC()
			ENDFOR

			FOR n:=0 TO 255 STEP 4
				clear(bm,n)
				pa(bm)
			EXITIF CtrlC()
			ENDFOR

			FOR n:=0 TO 255 STEP 8
				clear(bm,255-n)
				draw3d(bm,10,10,10,0.2,a/64.1,a/32.1,30,n>>1,"TRHD")
				pa(bm)
				a++
			EXITIF CtrlC()
			ENDFOR

			FOR n:=0 TO 255 STEP 8
				gradv(bm,n,0)
				draw3d(bm,10,10,10,0.2,a/64.1,a/32.1,30,127+n>>1,"TRHD")
				pa(bm)
				a++
			EXITIF CtrlC()
			ENDFOR

			FOR n:=0 TO 255 STEP 2
				gradv(bm,255,0)
				draw3d(bm,10,10,10,0.2,a/64.1,a/32.1,30,127+n>>1,"TRHD")
				pa(bm)
				a++
			EXITIF CtrlC()
			ENDFOR

			FOR n:=0 TO 255 STEP 4
				gradv(bm,255-n,0)
				draw3d(bm,10,10,10,0.2,a/64.1,a/32.1,30,255-n,"TRHD")
				pa(bm)
				a++
			EXITIF CtrlC()
			ENDFOR

			FOR n:=0 TO 255 STEP 4
				fade(bm,bmx,0,n)
				pa(bm)
			EXITIF CtrlC()
			ENDFOR

			Delay(200)

			FOR n:=0 TO HEIGHT-1
				copy(bm,bmx)
				move(bm,bmy,HEIGHT-1-n,HEIGHT-1-n)
				pa(bm)
			EXITIF CtrlC()
			ENDFOR

			FOR n:=0 TO 255 STEP 4
				fade(bm,bmy,0,255-n)
				c:=n	//255	//j*4
				draw3d(bm,10,10,10,0.2,a/64.1,a/32.1,30,c,"CUBE")
				pa(bm)
				a++
			EXITIF CtrlC()
			ENDFOR

			FOR n:=0 TO 255 STEP 4
				blur(bm,n/32)
				c:=255	//j*4
				draw3d(bm,10,10,10,0.2,a/64.1,a/32.1,30,c,"CUBE")
//				invert(bm)
				pa(bm)
//				invert(bm)
				a++
			EXITIF CtrlC()
			ENDFOR

			FOR n:=0 TO 255 STEP 4
				blur(bm,(255-n)/32)
				c:=255	//j*4
				draw3d(bm,10,10,10,0.2,a/64.1,a/32.1,30,c,"CUBE")
//				invert(bm)
				pa(bm)
//				invert(bm)
				a++
			EXITIF CtrlC()
			ENDFOR

			FOR n:=0 TO 255 STEP 4
				fade(bm,bmg,0,n)
				c:=255-n
				draw3d(bm,10,10,10,0.2,a/64.1,a/32.1,30,c,"CUBE")
				pa(bm)
				a++
			EXITIF CtrlC()
			ENDFOR

			FOR n:=0 TO 255 STEP 4
				spread(bm,bmt,bmg,n)
				pa(bm)
			EXITIF CtrlC()
			ENDFOR

			FOR n:=WIDTH-1 DTO -20
				fadeside(bm,bmb,bmt,n,n+20)
				pa(bm)
			EXITIF CtrlC()
			ENDFOR

			FOR n:=0 TO 255
				spread(bm,bma,bmb,n)
				pa(bm)
			EXITIF CtrlC()
			ENDFOR
			Delay(100)

			FOR n:=0 TO 255 STEP 12
				spread(bm,bmm,bma,n)
				pa(bm)
			EXITIF CtrlC()
			ENDFOR

		end(bmm)
		ENDIF
		end(bma)
		ENDIF
		end(bmt)
		ENDIF
		end(bmb)
		ENDIF
		end(bmg)
		ENDIF
		end(bmy)
		ENDIF
		end(bmx)
		ENDIF

/*
		DEF	bmy
		IF bmx:=load('gfx/demo_xicht1.bin',800)
			IF bmy:=load('gfx/demo_xicht2.bin')
				FOR n:=0 TO 255
					spread(bm,bmx,bmy,n)
					pa(bm)
				ENDFOR
			ENDIF
		ENDIF
*/
		end(bm)
	ENDIF
ENDPROC
*/
/*
// print ascii
PROC pa(bitmap:PTR TO UB)
	DEF	table=' .:,-;"^|(T?<uf{UCKAGOQB&%mM#$B@':PTR TO CHAR,tabmax=16
	DEF	buffer[(WIDTH+1)*HEIGHT]:CHAR,n=0,m=0,x,y
	FOR y:=0 TO HEIGHT-1
		FOR x:=0 TO WIDTH-1
			buffer[n++]:=table[bitmap[m++]>>3]
		ENDFOR
		buffer[n++]:="\n"
	ENDFOR
	Write(stdout,'\j012',1)
	Write(stdout,buffer,(WIDTH+1)*HEIGHT)
	Delay(1)
ENDPROC
*/
PROC clear(bitmap:PTR TO CHAR,byte)
	DEF	n=WIDTH*HEIGHT
	WHILE n
		n--
		bitmap[n]:=byte
	ENDWHILE
ENDPROC

PROC gradv(bm:PTR TO UB,a,b)
	DEF	x,y,n=0,i
	FOR y:=0 TO HEIGHT-1
		i:=(HEIGHT-y)*b/HEIGHT+y*a/HEIGHT
		FOR x:=0 TO WIDTH-1
			bm[n++]:=i
		ENDFOR
	ENDFOR
ENDPROC

PROC gradh(bm:PTR TO UB,a,b)
	DEF	x,y,n=0,i
	FOR x:=0 TO WIDTH-1
		i:=(WIDTH-x)*b/WIDTH+x*a/WIDTH
		FOR y:=0 TO HEIGHT-1
			bm[x+y*WIDTH]:=i
		ENDFOR
	ENDFOR
ENDPROC

PROC drawline(bm:PTR TO UB,x1:F,y1:F,x2:F,y2:F,c,hard="S")
	DEFD	hl=FAbs(x2-x1),vl=FAbs(y2-y1)
	DEFD	length=IF hl>vl THEN hl ELSE vl
	DEFF	deltax=(x2-x1)/length,deltay=(y2-y1)/length
	DEF	i=0
	WHILE i<length
		DEFUL	x=x1+=deltax,y=y1+=deltay
		IF x<WIDTH&&y<HEIGHT&&x>=0&&y>=0
			IF hard="S"
				IF bm[x+y*WIDTH]+c>=255
					bm[x+y*WIDTH]:=255
				ELSE
					bm[x+y*WIDTH]+=c
				ENDIF
			ELSE
				bm[x+y*WIDTH]:=c
			ENDIF
		ENDIF
		i++
	ENDWHILE
ENDPROC

PROC copy(dst:PTR TO UB,src:PTR TO UB)
	DEF	n
	n:=WIDTH*HEIGHT
	WHILE n
		n--
		dst[n]:=src[n]
	ENDWHILE
ENDPROC

PROC new()(PTR TO UB) IS AllocMem(WIDTH*HEIGHT,MEMF_PUBLIC)
PROC end(bm) DO FreeMem(bm,WIDTH*HEIGHT)

PROC persp(x:F,y:F,z:F,ax:D,ay:D,az:D,cl:D)(F,F,BOOL)
	DEFF	x1,y1,z1,xx,yy,zz,l

	x1:=x*Cos(az)+y*Sin(az)
	y1:=y*Cos(az)-x*Sin(az)
	xx:=x1*Cos(ay)+z*Sin(ay)
	z1:=z*Cos(ay)-x1*Sin(ay)
	zz:=z1*Cos(ax)+y1*Sin(ax)
	yy:=y1*Cos(ax)-z1*Sin(ax)

	l:=cl-zz
	IF l>0.0
		x:=xx*1.5*cl/l
		y:=yy*cl/l
	ELSE
		RETURN 0,0,TRUE
	ENDIF
//	PrintF('\d,\d\n',x,y)
ENDPROC x+WIDTH/2,y+HEIGHT/2,FALSE

PROC load(name,offset=0)(PTR TO UB)
	DEF	bm,fi
	IF bm:=new()
		IF fi:=Open(name,OLDFILE)
			Read(fi,bm,offset)
			Read(fi,bm,WIDTH*HEIGHT)
/*
			DEF	n
			n:=WIDTH*HEIGHT
			WHILE n
				n--
				bm[n]:=255-bm[n]
			ENDWHILE
*/
			Close(fi)
		ENDIF
	ENDIF
ENDPROC bm

PROC move(dst:PTR TO UB,bm:PTR TO UB,x,y)
	DEF	sx,sy,dx,dy,wi,he
	IF x>=0
		sx:=0
		dx:=x
		wi:=WIDTH-x
	ELSE
		sx:=-x
		dx:=0
		wi:=WIDTH+x
	ENDIF
	IF y>=0
		sy:=0
		dy:=y
		he:=HEIGHT-y
	ELSE
		sy:=-y
		dy:=0
		he:=HEIGHT+y
	ENDIF
	FOR y:=0 TO he-1
		FOR x:=0 TO wi-1
			dst[dx+x+(dy+y)*WIDTH]:=bm[sx+x+(sy+y)*WIDTH]
		ENDFOR
	ENDFOR
ENDPROC

PROC Draw3D(bm:PTR TO d_bitmap,nx,ny,nz,ax:F,ay:F,az:F,ll,c,type="CUBE",hard="S",dy=0)
	DEF	cube:PTR TO L,poly:PTR TO L,cnt,i,x,y,px,py,fx,fy,n
	SELECT type
	CASE "CUBE"
		cube:=[
				-nx,-ny,-nz,
				-nx,-ny,+nz,
				+nx,-ny,+nz,
				+nx,-ny,-nz,
				-nx,+ny,-nz,
				-nx,+ny,+nz,
				+nx,+ny,+nz,
				+nx,+ny,-nz]:L
		poly:=[
				4,0,1,2,3,
				4,4,5,6,7,
				2,0,4,
				2,1,5,
				2,2,6,
				2,3,7,
				0]:L
	CASE "TRHD"
		cube:=[
				0,-10,0,
				-nx,+7,+nz,
				+nx,+7,+nz,
				0,+7,-nz]:L
		poly:=[
				3,1,2,3,
				2,0,1,
				2,0,2,
				2,0,3,
				0]:L
	ENDSELECT
	n:=0
	WHILE cnt:=poly[n]
		n++
		i:=0
		WHILE i<cnt
			x,y:=persp(cube[poly[n]*3],cube[poly[n]*3+1],cube[poly[n]*3+2],ax,ay,az,ll)
			IF i=0
				fx:=px:=x
				fy:=py:=y
			ELSE
				IF i=cnt-1
					DrawLine(bm,x,y+dy,fx,fy+dy,c,hard)
					DrawLine(bm,x,y+dy,px,py+dy,c,hard)
				ELSE
					DrawLine(bm,x,y+dy,px,py+dy,c,hard)
				ENDIF
				px:=x
				py:=y
			ENDIF
			i++
			n++
		ENDWHILE
	ENDWHILE
ENDPROC
