#ifndef EDWAVEFORM_H
#define EDWAVEFORM_H

#include <QWidget>
#include <QLabel>
#include "dmengine.h"

class QEDWaveTrackDisplay : public QWidget
{
    Q_OBJECT

public:
    QEDWaveTrackDisplay(QWidget *parent = 0);

    void setWaveform(void *mdata, int msize, int mformat, int mchannels, int mfreq);
    float getScaledWidth();
    void setScale(const float mscale);
    int getBps();
    float getDuration();
    float getTimeScale(float value);
    float getTimeFromCoord(float value);
    float getTime();
    float getOffset();

    QSize minimumSizeHint() const
    {
        return QSize(100, 60);
    }

    QSize sizeHint() const
    {
        return QSize(600, 60);
    }

public slots:
    void setTime(const float mtime);
    void setOffset(const float moffs);
    void setSelection(const float mstart, const float mend);
    void clearSelection();

signals:
    void selectionChanged(float mstart, float mduration);
    void timeChanged(float value);
    void offsetChanged(float value);

protected:
    void mousePressEvent(QMouseEvent *event);
    void mouseMoveEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);

    void paintEvent(QPaintEvent *event);

private:
    float scale, time, offs, duration; // in milliseconds
    int size, channels, format, freq, sduration;
    void *data;

    bool selectionValid;
    float selectionStart, selectionDuration;

    QPoint selectionPoint, dragPoint;
    bool selecting, dragging;
    float selectionOffs, dragOffs;
};


class QEDWaveTrackView : public QWidget
{
    Q_OBJECT

private:
    QEDWaveTrackDisplay *wave;
    QLabel *infoName, *infoData;

public:

    QEDWaveTrackView(QWidget *parent = 0);
    void setWaveform(void *mdata, int mlen, int mformat, int mchannels, int mfreq);
    void setName(QString name);
    void setTime(const float mtime);
    void setOffset(const float moffs);
    float getScaledWidth();
    void setScale(const float mscale);
    float getDuration();
    float getTime();
    float getOffset();

private slots:
    void slotTimeChanged(float value);
    void slotOffsetChanged(float value);

signals:
    void timeChanged(float value);
    void offsetChanged(float value);
};

#endif
