#include "edres.h"
#include "dmengine.h"


QEDResourceModel::QEDResourceModel(QObject *parent)
    : QAbstractTableModel(parent)
{
}


int QEDResourceModel::rowCount(const QModelIndex &parent) const
{
    Q_UNUSED(parent);
    return nengineEffects;
}


int QEDResourceModel::columnCount(const QModelIndex &parent) const
{
    Q_UNUSED(parent);
    return 2;
}


QVariant QEDResourceModel::data(const QModelIndex &index, int role) const
{
    if (!index.isValid())
        return QVariant();

    if (index.row() >= nengineEffects || index.row() < 0)
        return QVariant();

    if (role == Qt::DisplayRole)
    {
        DMEffect *ef = &engineEffects[index.row()];
        switch (index.column())
        {
            case 0:
                return QString(ef->name);

            case 1:
                return QVariant(ef->nparams);
        }
    }
    return QVariant();
}


QVariant QEDResourceModel::headerData(int section, Qt::Orientation orientation, int role) const
{
    if (role != Qt::DisplayRole)
        return QVariant();

    if (orientation == Qt::Horizontal)
    {
        switch (section) {
            case 0:
                return "Name";

            case 1:
                return "# params";
        }
    }
    return QVariant();
}


Qt::ItemFlags QEDResourceModel::flags(const QModelIndex &index) const
{
    if (!index.isValid())
        return Qt::ItemIsEnabled;

    return QAbstractTableModel::flags(index); // | Qt::ItemIsEditable;
}
