#ifndef EDMAIN_H
#define EDMAIN_H

// Program name etc
#define PROGRAM_NAME      "DMPE Editor"
#define PROGRAM_VERSION   "0.1"

// Defaults
#define DOC_DEF_FILENAME  "Untitled"
#define DOC_UNDO_MAX	  15

enum
{
    CTRL_REWIND,
    CTRL_PLAY_START,
    CTRL_PLAY_CURRENT,
    CTRL_PAUSE
};

#define CTRL_ICON_SIZE   32

#include "edtlobj.h"
#include "edview.h"
#include "edwaveform.h"
#include "edtimeline.h"
#include "edres.h"
#include <QDebug>
#include <QFile>
#include <QApplication>
#include <QMainWindow>
#include <QTableView>
#include <QAction>
#include <QActionGroup>
#include <QSlider>
#include <QMessageBox>
#include <QCheckBox>
#include <QScrollBar>

class DemoEditor : public QMainWindow
{
    Q_OBJECT

public:
    DemoEditor();
    ~DemoEditor();

    void settingsRestore();
    void settingsSave();


private slots:
    void actionFileNew();
    void actionFileOpen();
    void actionFileSave();
    void actionFileSaveAs();

    void actionAboutBox();
    
    //void actionCut();
    //void actionCopy();
    //void actionPaste();
    //void actionDelete();
    
    void performUndo();
    void performRedo();

    void actionControlChanged(QAction *);
    void actionTimelineScrollChanged(int);
    void actionOffsetChanged(float);
    void actionTimeChanged(float);
    void actionTimelineChanged();

private:
    QAction *menuActUndo, *menuActRedo, *menuActOpen, *menuActSave, *menuActSaveAs;
//    QAction *menuActCut, *menuActCopy, *menuActPaste, *menuActDelete;
    QActionGroup *actGroupControls;
    QScrollBar *timelineScrollBar;
    QTableView *resourceView;
    QEDResourceModel *resourceModel;
    QEDWaveTrackView *timelineAudioTrack;
    QEDTimelineView *timelineView;
    QEDGLDemoView *demoView;
    
    

    QAction * createToolButton(QActionGroup *group, QString name, QIcon icon, QString statustip, QVariant data);
    QAction * createMenuAction(QString name, const QKeySequence &shortcut, QString tooltip);
    QAction * createMenuGroupAction(QMenu *, QActionGroup *, QString name, const QKeySequence &shortcut, QString tooltip, QVariant data);
    void setActionGroupChecked(QActionGroup *group, QVariant data);


    void showFileErrorDialog(QString operation, int code);
    QMessageBox::StandardButton showDocumentModifiedDialog();
    void statusMsg(QString message);
    void closeEvent(QCloseEvent *event);
    void createMainGUI();
    void updateResourceView();
    void updateMenuStates();
    void updateTimelineView();

    int initEffectsAndResources();
    void shutdownEffectsAndResources();
    void rehash();
    int reopenResources();
    int loadResources();
    bool initializeVideo();
    int getTimelineDuration();    

    void createNewFile();
    void readFromFile(QString filename);
    void saveToFile(QString filename);


    bool initSDL;
    float currViewScale;
    int currViewOffset;
    int currFrameTime;

    EDTimelineObject *currTimeline;
    DMEngineData engine;

    QList<EDTimelineObject *> undoHistory;
    int undoHistoryPos, undoHistoryMax;

    void historyReset();
    void historyPush(QString description);
    void historyTop();
    void historyPop();
};


#endif // EDMAIN_H
