/*
 * DMLib
 * -- Scaled sprite / surface blitting function template
 * Programmed and designed by Matti 'ccr' Hamalainen
 * (C) Copyright 2011-2012 Tecnic Software productions (TNSP)
 */


int DM_BLITFUNC_NAME (SDL_Surface *src,
    const int x0, const int y0,
    const int dwidth, const int dheight,
    SDL_Surface *dst
#ifdef DM_BLITFUNC_ARGS
    DM_BLITFUNC_ARGS
#endif
    )
#ifdef DM_HEADER
;
#else
{
    int yc;
    DMFixedPoint32 xv, yv, dx, dy;
    DMQValue xr, yr;

#ifdef DM_BLITFUNC_VARS
    DM_BLITFUNC_VARS
#endif
    
    // Clip coordinates
    if (dmScaledClipCoord(&xr, x0, src->w, dwidth, 
        dst->clip_rect.x, dst->clip_rect.x + dst->clip_rect.w)
        ||
        dmScaledClipCoord(&yr, y0, src->h, dheight,
        dst->clip_rect.y, dst->clip_rect.y + dst->clip_rect.h))
        return -1;

#ifdef DM_BLITFUNC_INIT
    DM_BLITFUNC_INIT
#endif

    // Calculate "final" initial source bitmap offsets
    FP_CONV(dy, yr.voffs);
    FP_MUL_R(yv, dy, yr.vdelta);

    FP_CONV(dx, xr.voffs);
    FP_MUL_R(dx, dx, xr.vdelta);

    // Take pitch into account
    const int dstadd = xr.vadd - dst->clip_rect.w + dst->clip_rect.x + (dst->pitch / DM_BLITFUNC_DST_BYTES);

    // Blit scaled
    DM_BLITFUNC_DST_TYPE * dp = ((DM_BLITFUNC_DST_TYPE *) dst->pixels) + (yr.v0 * dst->pitch) / DM_BLITFUNC_DST_BYTES + xr.v0;
    for (yc = yr.v0; yc < yr.v1; yc++)
    {
        const DM_BLITFUNC_SRC_TYPE * sp = ((DM_BLITFUNC_SRC_TYPE *) src->pixels) + (FP_GETH(yv) * src->pitch) / DM_BLITFUNC_SRC_BYTES;
        int xc;

#ifdef DM_BLITFUNC_INNER_INIT
        DM_BLITFUNC_INNER_INIT
#endif

        for (xv.dw = dx.dw, xc = xr.v0; xc < xr.v1; xc++)
        {
            DM_BLITFUNC_INNER
            FP_ADD(xv, xr.vdelta);
        }
        FP_ADD(yv, yr.vdelta);
        dp += dstadd;
    }

#ifdef DM_BLITFUNC_FINISH
    DM_BLITFUNC_FINISH
#endif

    return 0;
}
#endif

#undef DM_BLITFUNC_NAME
#undef DM_BLITFUNC_ARGS
#undef DM_BLITFUNC_SRC_BYTES
#undef DM_BLITFUNC_DST_BYTES
#undef DM_BLITFUNC_SRC_TYPE
#undef DM_BLITFUNC_DST_TYPE
#undef DM_BLITFUNC_VARS
#undef DM_BLITFUNC_INIT
#undef DM_BLITFUNC_INNER_INIT
#undef DM_BLITFUNC_INNER
#undef DM_BLITFUNC_FINISH
