/*
 * DMLib
 * -- Resource management
 * Programmed and designed by Matti 'ccr' Hamalainen
 * (C) Copyright 2011-2012 Tecnic Software productions (TNSP)
 */
#include "dmresw.h"

int dmf_write_str(DMResource *f, void *s, size_t l)
{
    return dmfwrite(s, 1, l, f) == l;
}


BOOL dmf_write_byte(DMResource *f, const Uint8 val)
{
    return dmfputc(val, f) == val;
}


#define DM_DEFINE_FUNC(xname, xtype, xmacro)            \
BOOL dmf_write_ ## xname (DMResource *f, xtype v) {     \
    xtype result = DM_NATIVE_TO_ ## xmacro (v);         \
    if (dmfwrite(&result, sizeof( xtype ), 1, f) != 1)  \
        return FALSE;                                   \
    return TRUE;                                        \
}

DM_DEFINE_FUNC(le16, Uint16, LE16)
DM_DEFINE_FUNC(le32, Uint32, LE32)

DM_DEFINE_FUNC(be16, Uint16, BE16)
DM_DEFINE_FUNC(be32, Uint32, BE32)

#ifdef DM_HAVE_64BIT
DM_DEFINE_FUNC(le64, Uint64, LE64)
DM_DEFINE_FUNC(be64, Uint64, BE64)
#endif
