/*
 * DMLib
 * -- Standard I/O (stdio) file write/read endianess helpers
 * Programmed and designed by Matti 'ccr' Hamalainen
 * (C) Copyright 2011 Tecnic Software productions (TNSP)
 */
#ifndef DMFILE_H
#define DMFILE_H

#include "dmlib.h"

#ifdef __cplusplus
extern "C" {
#endif


/* Plain file endianess functions
 */
#define DM_DEFINE_FFUNC(xname, xtype, z)          \
BOOL    dm_fread_ ## xname (FILE *f, xtype *v);  \
BOOL    dm_fwrite_ ## xname (FILE *f, const xtype v);

#include "dmfiletmpl.h"

#undef DM_DEFINE_FFUNC

BOOL    dm_fread_str(FILE *f, void *, const size_t);
BOOL    dm_fwrite_str(FILE *f, const void *, const size_t);

BOOL    dm_fread_byte(FILE *f, Uint8 *);
BOOL    dm_fwrite_byte(FILE *f, const Uint8);


int     dmReadDataFile(FILE *inFile, const char *filename, Uint8 **buf, size_t *size);


#ifdef __cplusplus
}
#endif

#endif // DMFILE_H
