/*
 * Simple commandline argument processing functions
 * Programmed and designed by Matti 'ccr' Hamalainen
 * (C) Copyright 2002-2008 Tecnic Software productions (TNSP)
 *
 * Please read file 'COPYING' for information on license and distribution.
 */
#ifndef DMARGS_H
#define DMARGS_H

#include "dmlib.h"
#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Option flags
 */
#define OPT_NONE       (0)    // Simple option with no arguments
#define OPT_ARGREQ     (1)    // Option's argument is required
#define OPT_ARGOPT     (3)    // Option's argument is optional
#define OPT_ARGMASK    (3)    // Mask for option argument flags
#define OPT_REQUIRED   (4)    // This option is required to be given

typedef struct {
    int id;
    char optShort;
    char *optLong;
    char *desc;
    int flags;
} DMOptArg;

BOOL dmArgsProcess(int argc, char *argv[],
     DMOptArg argList[], int argListN,
     BOOL (*handleOpt)(int, char *, char *),
     BOOL (*handleFile)(char *), BOOL);

void dmArgsPrintHelp(FILE *, DMOptArg optList[], int optListN);

#ifdef __cplusplus
}
#endif
#endif // DMARGS_H
