/*
 * Decompiled with CFR 0.152.
 */
package saito.objloader;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import processing.core.PImage;
import saito.objloader.Debug;

public class Material {
    public PImage map_Kd;
    public float[] Ka;
    public float[] Kd;
    public float[] Ks;
    public float d;
    public String mtlName;
    protected int[] tex = new int[1];

    public Material() {
        this.Ka = new float[4];
        this.Kd = new float[4];
        this.Ks = new float[4];
        int i = 0;
        while (i < this.Ka.length) {
            if (i == 3) {
                this.Ka[i] = 1.0f;
                this.Kd[i] = 1.0f;
                this.Ks[i] = 1.0f;
            } else {
                this.Ka[i] = 0.5f;
                this.Kd[i] = 0.5f;
                this.Ks[i] = 0.5f;
            }
            ++i;
        }
        this.d = 1.0f;
        this.mtlName = "default";
    }

    public void setupGL(GL gl, Debug debug) {
        if (this.map_Kd != null) {
            this.map_Kd.loadPixels();
            IntBuffer glPixels = this.setupIntBuffer(this.map_Kd.pixels);
            gl.glGenTextures(1, this.tex, 0);
            gl.glBindTexture(3553, this.tex[0]);
            gl.glTexParameteri(3553, 10241, 9728);
            gl.glTexParameteri(3553, 10240, 9728);
            gl.glTexParameteri(3553, 10242, 10497);
            gl.glTexParameteri(3553, 10243, 10497);
            gl.glTexImage2D(3553, 0, 6408, this.map_Kd.width, this.map_Kd.height, 0, 32993, 5121, (Buffer)glPixels);
        }
    }

    public void beginDrawGL(GL gl, boolean useMaterial, boolean useTexture) {
        if (useMaterial) {
            gl.glMaterialfv(1028, 4608, this.Ka, 0);
            if (this.Kd[3] == 1.0f) {
                gl.glMaterialfv(1028, 5634, this.Kd, 0);
            } else {
                gl.glMaterialfv(1028, 5634, this.Kd, 0);
                gl.glMaterialfv(1028, 4610, this.Ks, 0);
            }
            if (this.map_Kd != null && useTexture) {
                gl.glBindTexture(3553, this.tex[0]);
                gl.glEnable(3553);
            }
        }
    }

    public void endDrawGL(GL gl, boolean useMaterial, boolean useTexture) {
        if (useMaterial && this.map_Kd != null && useTexture) {
            gl.glDisable(3553);
        }
    }

    private IntBuffer setupIntBuffer(int[] i) {
        IntBuffer fb = ByteBuffer.allocateDirect(4 * i.length).order(ByteOrder.nativeOrder()).asIntBuffer();
        fb.put(i);
        fb.rewind();
        return fb;
    }
}

